/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.internal.jx;
import com.google.android.gms.maps.internal.aa;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.e;
import com.google.android.gms.maps.model.f;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final e CREATOR = new e();
    public static final float NO_DIMENSION = -1.0f;
    private final int CK;
    private BitmapDescriptor ama;
    private LatLng amb;
    private float amc;
    private float amd;
    private LatLngBounds ame;
    private float alQ;
    private float alX;
    private boolean alY = true;
    private float amf = 0.0f;
    private float amg = 0.5f;
    private float amh = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.CK = versionCode;
        this.ama = new BitmapDescriptor(d.a.ap((IBinder)wrappedImage));
        this.amb = location;
        this.amc = width;
        this.amd = height;
        this.ame = bounds;
        this.alQ = bearing;
        this.alX = zIndex;
        this.alY = visible;
        this.amf = transparency;
        this.amg = anchorU;
        this.amh = anchorV;
    }

    public GroundOverlayOptions() {
        this.CK = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (aa.ob()) {
            f.a(this, out, flags);
        } else {
            e.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder od() {
        return this.ama.nA().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.ama = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.amg = u2;
        this.amh = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        jx.a((this.ame == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        jx.b((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        jx.b((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        jx.a((this.ame == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        jx.b((location != null ? 1 : 0) != 0, (Object)"Location must be specified");
        jx.b((width >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        jx.b((height >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.amb = latLng;
        this.amc = f2;
        this.amd = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        jx.a((this.amb == null ? 1 : 0) != 0, (Object)("Position has already been set using position: " + this.amb));
        this.ame = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.alQ = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.alX = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.alY = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        jx.b((transparency >= 0.0f && transparency <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.amf = transparency;
        return this;
    }

    int getVersionCode() {
        return this.CK;
    }

    public BitmapDescriptor getImage() {
        return this.ama;
    }

    public LatLng getLocation() {
        return this.amb;
    }

    public float getWidth() {
        return this.amc;
    }

    public float getHeight() {
        return this.amd;
    }

    public LatLngBounds getBounds() {
        return this.ame;
    }

    public float getBearing() {
        return this.alQ;
    }

    public float getZIndex() {
        return this.alX;
    }

    public float getTransparency() {
        return this.amf;
    }

    public float getAnchorU() {
        return this.amg;
    }

    public float getAnchorV() {
        return this.amh;
    }

    public boolean isVisible() {
        return this.alY;
    }
}

