/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.location.Location;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.IProjectionDelegate;
import com.google.android.gms.maps.internal.IUiSettingsDelegate;
import com.google.android.gms.maps.internal.b;
import com.google.android.gms.maps.internal.d;
import com.google.android.gms.maps.internal.e;
import com.google.android.gms.maps.internal.f;
import com.google.android.gms.maps.internal.g;
import com.google.android.gms.maps.internal.h;
import com.google.android.gms.maps.internal.j;
import com.google.android.gms.maps.internal.k;
import com.google.android.gms.maps.internal.l;
import com.google.android.gms.maps.internal.m;
import com.google.android.gms.maps.internal.n;
import com.google.android.gms.maps.internal.o;
import com.google.android.gms.maps.internal.p;
import com.google.android.gms.maps.internal.q;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.IPolylineDelegate;
import com.google.android.gms.maps.model.internal.c;
import com.google.android.gms.maps.model.internal.h;
import com.google.android.gms.maps.model.internal.i;
import com.google.android.gms.maps.model.internal.j;
import com.google.android.gms.maps.model.internal.l;
import com.google.android.gms.maps.model.internal.m;
import com.google.android.gms.maps.model.internal.n;

public interface IGoogleMapDelegate
extends IInterface {
    public CameraPosition getCameraPosition() throws RemoteException;

    public float getMaxZoomLevel() throws RemoteException;

    public float getMinZoomLevel() throws RemoteException;

    public void moveCamera(com.google.android.gms.dynamic.d var1) throws RemoteException;

    public void animateCamera(com.google.android.gms.dynamic.d var1) throws RemoteException;

    public void animateCameraWithCallback(com.google.android.gms.dynamic.d var1, b var2) throws RemoteException;

    public void animateCameraWithDurationAndCallback(com.google.android.gms.dynamic.d var1, int var2, b var3) throws RemoteException;

    public void stopAnimation() throws RemoteException;

    public IPolylineDelegate addPolyline(PolylineOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.m addPolygon(PolygonOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.l addMarker(MarkerOptions var1) throws RemoteException;

    public i addGroundOverlay(GroundOverlayOptions var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.n addTileOverlay(TileOverlayOptions var1) throws RemoteException;

    public void clear() throws RemoteException;

    public int getMapType() throws RemoteException;

    public void setMapType(int var1) throws RemoteException;

    public boolean isTrafficEnabled() throws RemoteException;

    public void setTrafficEnabled(boolean var1) throws RemoteException;

    public boolean isIndoorEnabled() throws RemoteException;

    public boolean setIndoorEnabled(boolean var1) throws RemoteException;

    public boolean isMyLocationEnabled() throws RemoteException;

    public void setMyLocationEnabled(boolean var1) throws RemoteException;

    public Location getMyLocation() throws RemoteException;

    public void setLocationSource(ILocationSourceDelegate var1) throws RemoteException;

    public IUiSettingsDelegate getUiSettings() throws RemoteException;

    public IProjectionDelegate getProjection() throws RemoteException;

    public void setOnCameraChangeListener(f var1) throws RemoteException;

    public void setOnMapClickListener(j var1) throws RemoteException;

    public void setOnMapLongClickListener(l var1) throws RemoteException;

    public void setOnMarkerClickListener(n var1) throws RemoteException;

    public void setOnMarkerDragListener(o var1) throws RemoteException;

    public void setOnInfoWindowClickListener(h var1) throws RemoteException;

    public void setInfoWindowAdapter(d var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.h addCircle(CircleOptions var1) throws RemoteException;

    public void setOnMyLocationChangeListener(q var1) throws RemoteException;

    public void setOnMyLocationButtonClickListener(p var1) throws RemoteException;

    public void snapshot(v var1, com.google.android.gms.dynamic.d var2) throws RemoteException;

    public void setPadding(int var1, int var2, int var3, int var4) throws RemoteException;

    public boolean isBuildingsEnabled() throws RemoteException;

    public void setBuildingsEnabled(boolean var1) throws RemoteException;

    public void setOnMapLoadedCallback(k var1) throws RemoteException;

    public com.google.android.gms.maps.model.internal.j getFocusedBuilding() throws RemoteException;

    public void setOnIndoorStateChangeListener(g var1) throws RemoteException;

    public void getMapAsync(m var1) throws RemoteException;

    public void onCreate(Bundle var1) throws RemoteException;

    public void onResume() throws RemoteException;

    public void onPause() throws RemoteException;

    public void onDestroy() throws RemoteException;

    public void onLowMemory() throws RemoteException;

    public boolean useViewLifecycleWhenInFragment() throws RemoteException;

    public void onSaveInstanceState(Bundle var1) throws RemoteException;

    public void setContentDescription(String var1) throws RemoteException;

    public void moveCamera2(c var1) throws RemoteException;

    public void animateCamera2(c var1) throws RemoteException;

    public void animateCameraWithCallback2(c var1, b var2) throws RemoteException;

    public void animateCameraWithDurationAndCallback2(c var1, int var2, b var3) throws RemoteException;

    public com.google.android.gms.maps.model.internal.l addMarker2(MarkerOptions var1, com.google.android.gms.maps.model.internal.p var2) throws RemoteException;

    public void setInfoWindowRenderer(e var1) throws RemoteException;

    public i addGroundOverlay2(GroundOverlayOptions var1, com.google.android.gms.maps.model.internal.e var2) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.IGoogleMapDelegate$a
    extends Binder
    implements IGoogleMapDelegate {
        public static IGoogleMapDelegate aT(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
            if (iInterface != null && iInterface instanceof IGoogleMapDelegate) {
                return (IGoogleMapDelegate)iInterface;
            }
            return new a(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CameraPosition cameraPosition = this.getCameraPosition();
                    reply.writeNoException();
                    if (cameraPosition != null) {
                        reply.writeInt(1);
                        cameraPosition.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f2 = this.getMaxZoomLevel();
                    reply.writeNoException();
                    reply.writeFloat(f2);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    float f3 = this.getMinZoomLevel();
                    reply.writeNoException();
                    reply.writeFloat(f3);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d2 = d.a.ap((IBinder)data.readStrongBinder());
                    this.moveCamera(d2);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d3 = d.a.ap((IBinder)data.readStrongBinder());
                    this.animateCamera(d3);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d4 = d.a.ap((IBinder)data.readStrongBinder());
                    b b2 = b.a.aR(data.readStrongBinder());
                    this.animateCameraWithCallback(d4, b2);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.dynamic.d d5 = d.a.ap((IBinder)data.readStrongBinder());
                    int n2 = data.readInt();
                    b b3 = b.a.aR(data.readStrongBinder());
                    this.animateCameraWithDurationAndCallback(d5, n2, b3);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.stopAnimation();
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolylineOptions polylineOptions = 0 != data.readInt() ? PolylineOptions.CREATOR.dh(data) : null;
                    IPolylineDelegate iPolylineDelegate = this.addPolyline(polylineOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(iPolylineDelegate != null ? iPolylineDelegate.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    PolygonOptions polygonOptions = 0 != data.readInt() ? PolygonOptions.CREATOR.dg(data) : null;
                    com.google.android.gms.maps.model.internal.m m2 = this.addPolygon(polygonOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(m2 != null ? m2.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    MarkerOptions markerOptions = 0 != data.readInt() ? MarkerOptions.CREATOR.df(data) : null;
                    com.google.android.gms.maps.model.internal.l l2 = this.addMarker(markerOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(l2 != null ? l2.asBinder() : null);
                    return true;
                }
                case 12: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    GroundOverlayOptions groundOverlayOptions = 0 != data.readInt() ? GroundOverlayOptions.CREATOR.dc(data) : null;
                    i i2 = this.addGroundOverlay(groundOverlayOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(i2 != null ? i2.asBinder() : null);
                    return true;
                }
                case 13: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    TileOverlayOptions tileOverlayOptions = 0 != data.readInt() ? TileOverlayOptions.CREATOR.dn(data) : null;
                    com.google.android.gms.maps.model.internal.n n3 = this.addTileOverlay(tileOverlayOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(n3 != null ? n3.asBinder() : null);
                    return true;
                }
                case 14: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.clear();
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n4 = this.getMapType();
                    reply.writeNoException();
                    reply.writeInt(n4);
                    return true;
                }
                case 16: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n5 = data.readInt();
                    this.setMapType(n5);
                    reply.writeNoException();
                    return true;
                }
                case 17: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isTrafficEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != data.readInt();
                    this.setTrafficEnabled(bl);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isIndoorEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != data.readInt();
                    boolean bl2 = this.setIndoorEnabled(bl);
                    reply.writeNoException();
                    reply.writeInt(bl2 ? 1 : 0);
                    return true;
                }
                case 21: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isMyLocationEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != data.readInt();
                    this.setMyLocationEnabled(bl);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Location location = this.getMyLocation();
                    reply.writeNoException();
                    if (location != null) {
                        reply.writeInt(1);
                        location.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 24: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    ILocationSourceDelegate iLocationSourceDelegate = ILocationSourceDelegate.a.aW(data.readStrongBinder());
                    this.setLocationSource(iLocationSourceDelegate);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IUiSettingsDelegate iUiSettingsDelegate = this.getUiSettings();
                    reply.writeNoException();
                    reply.writeStrongBinder(iUiSettingsDelegate != null ? iUiSettingsDelegate.asBinder() : null);
                    return true;
                }
                case 26: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    IProjectionDelegate iProjectionDelegate = this.getProjection();
                    reply.writeNoException();
                    reply.writeStrongBinder(iProjectionDelegate != null ? iProjectionDelegate.asBinder() : null);
                    return true;
                }
                case 27: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    f f4 = f.a.aZ(data.readStrongBinder());
                    this.setOnCameraChangeListener(f4);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    j j2 = j.a.bd(data.readStrongBinder());
                    this.setOnMapClickListener(j2);
                    reply.writeNoException();
                    return true;
                }
                case 29: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    l l3 = l.a.bf(data.readStrongBinder());
                    this.setOnMapLongClickListener(l3);
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    n n6 = n.a.bh(data.readStrongBinder());
                    this.setOnMarkerClickListener(n6);
                    reply.writeNoException();
                    return true;
                }
                case 31: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    o o2 = o.a.bi(data.readStrongBinder());
                    this.setOnMarkerDragListener(o2);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    h h2 = h.a.bb(data.readStrongBinder());
                    this.setOnInfoWindowClickListener(h2);
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    d d6 = d.a.aU(data.readStrongBinder());
                    this.setInfoWindowAdapter(d6);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    CircleOptions circleOptions = 0 != data.readInt() ? CircleOptions.CREATOR.db(data) : null;
                    com.google.android.gms.maps.model.internal.h h3 = this.addCircle(circleOptions);
                    reply.writeNoException();
                    reply.writeStrongBinder(h3 != null ? h3.asBinder() : null);
                    return true;
                }
                case 36: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    q q2 = q.a.bk(data.readStrongBinder());
                    this.setOnMyLocationChangeListener(q2);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    p p2 = p.a.bj(data.readStrongBinder());
                    this.setOnMyLocationButtonClickListener(p2);
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    v v2 = v.a.bq(data.readStrongBinder());
                    com.google.android.gms.dynamic.d d7 = d.a.ap((IBinder)data.readStrongBinder());
                    this.snapshot(v2, d7);
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    int n7 = data.readInt();
                    int n8 = data.readInt();
                    int n9 = data.readInt();
                    int n10 = data.readInt();
                    this.setPadding(n7, n8, n9, n10);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.isBuildingsEnabled();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 41: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = 0 != data.readInt();
                    this.setBuildingsEnabled(bl);
                    reply.writeNoException();
                    return true;
                }
                case 42: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    k k2 = k.a.be(data.readStrongBinder());
                    this.setOnMapLoadedCallback(k2);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    com.google.android.gms.maps.model.internal.j j3 = this.getFocusedBuilding();
                    reply.writeNoException();
                    reply.writeStrongBinder(j3 != null ? j3.asBinder() : null);
                    return true;
                }
                case 45: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    g g2 = g.a.ba(data.readStrongBinder());
                    this.setOnIndoorStateChangeListener(g2);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    m m3 = m.a.bg(data.readStrongBinder());
                    this.getMapAsync(m3);
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Bundle bundle = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.onCreate(bundle);
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onResume();
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onPause();
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onDestroy();
                    reply.writeNoException();
                    return true;
                }
                case 58: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.onLowMemory();
                    reply.writeNoException();
                    return true;
                }
                case 59: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    boolean bl = this.useViewLifecycleWhenInFragment();
                    reply.writeNoException();
                    reply.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 60: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    Bundle bundle = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.onSaveInstanceState(bundle);
                    reply.writeNoException();
                    if (bundle != null) {
                        reply.writeInt(1);
                        bundle.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 61: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    String string = data.readString();
                    this.setContentDescription(string);
                    reply.writeNoException();
                    return true;
                }
                case 64: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    c c2 = 0 != data.readInt() ? c.CREATOR.dq(data) : null;
                    this.moveCamera2(c2);
                    reply.writeNoException();
                    return true;
                }
                case 65: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    c c3 = 0 != data.readInt() ? c.CREATOR.dq(data) : null;
                    this.animateCamera2(c3);
                    reply.writeNoException();
                    return true;
                }
                case 66: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    c c4 = 0 != data.readInt() ? c.CREATOR.dq(data) : null;
                    b b4 = b.a.aR(data.readStrongBinder());
                    this.animateCameraWithCallback2(c4, b4);
                    reply.writeNoException();
                    return true;
                }
                case 67: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    c c5 = 0 != data.readInt() ? c.CREATOR.dq(data) : null;
                    int n11 = data.readInt();
                    b b5 = b.a.aR(data.readStrongBinder());
                    this.animateCameraWithDurationAndCallback2(c5, n11, b5);
                    reply.writeNoException();
                    return true;
                }
                case 68: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    MarkerOptions markerOptions = 0 != data.readInt() ? MarkerOptions.CREATOR.df(data) : null;
                    com.google.android.gms.maps.model.internal.p p3 = 0 != data.readInt() ? com.google.android.gms.maps.model.internal.p.CREATOR.ds(data) : null;
                    com.google.android.gms.maps.model.internal.l l4 = this.addMarker2(markerOptions, p3);
                    reply.writeNoException();
                    reply.writeStrongBinder(l4 != null ? l4.asBinder() : null);
                    return true;
                }
                case 69: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    e e2 = e.a.aV(data.readStrongBinder());
                    this.setInfoWindowRenderer(e2);
                    reply.writeNoException();
                    return true;
                }
                case 70: {
                    data.enforceInterface("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    GroundOverlayOptions groundOverlayOptions = 0 != data.readInt() ? GroundOverlayOptions.CREATOR.dc(data) : null;
                    com.google.android.gms.maps.model.internal.e e3 = 0 != data.readInt() ? com.google.android.gms.maps.model.internal.e.CREATOR.dr(data) : null;
                    i i3 = this.addGroundOverlay2(groundOverlayOptions, e3);
                    reply.writeNoException();
                    reply.writeStrongBinder(i3 != null ? i3.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class a
        implements IGoogleMapDelegate {
            private IBinder le;

            a(IBinder iBinder) {
                this.le = iBinder;
            }

            public IBinder asBinder() {
                return this.le;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraPosition getCameraPosition() throws RemoteException {
                CameraPosition cameraPosition;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    cameraPosition = 0 != parcel2.readInt() ? CameraPosition.CREATOR.da(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return cameraPosition;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMaxZoomLevel() throws RemoteException {
                float f2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    f2 = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getMinZoomLevel() throws RemoteException {
                float f2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    f2 = parcel2.readFloat();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return f2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveCamera(com.google.android.gms.dynamic.d update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    this.le.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCamera(com.google.android.gms.dynamic.d update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    this.le.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithCallback(com.google.android.gms.dynamic.d update, b callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.le.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithDurationAndCallback(com.google.android.gms.dynamic.d update, int durationMs, b callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(update != null ? update.asBinder() : null);
                    parcel.writeInt(durationMs);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.le.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopAnimation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IPolylineDelegate addPolyline(PolylineOptions options) throws RemoteException {
                IPolylineDelegate iPolylineDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    iPolylineDelegate = IPolylineDelegate.a.bC(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iPolylineDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.m addPolygon(PolygonOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.m m2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    m2 = m.a.bB(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return m2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.l addMarker(MarkerOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.l l2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    l2 = l.a.bA(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return l2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public i addGroundOverlay(GroundOverlayOptions options) throws RemoteException {
                i i2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    i2 = i.a.bx(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return i2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.n addTileOverlay(TileOverlayOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.n n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = n.a.bD(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clear() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMapType() throws RemoteException {
                int n2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    n2 = parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMapType(int type) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(type);
                    this.le.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTrafficEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTrafficEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.le.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isIndoorEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setIndoorEnabled(boolean enabled) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.le.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMyLocationEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMyLocationEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.le.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Location getMyLocation() throws RemoteException {
                Location location;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    location = 0 != parcel2.readInt() ? (Location)Location.CREATOR.createFromParcel(parcel2) : null;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return location;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLocationSource(ILocationSourceDelegate source) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(source != null ? source.asBinder() : null);
                    this.le.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IUiSettingsDelegate getUiSettings() throws RemoteException {
                IUiSettingsDelegate iUiSettingsDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    iUiSettingsDelegate = IUiSettingsDelegate.a.bu(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iUiSettingsDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IProjectionDelegate getProjection() throws RemoteException {
                IProjectionDelegate iProjectionDelegate;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    iProjectionDelegate = IProjectionDelegate.a.bp(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return iProjectionDelegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnCameraChangeListener(f listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapClickListener(j listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapLongClickListener(l listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMarkerClickListener(n listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMarkerDragListener(o listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnInfoWindowClickListener(h listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInfoWindowAdapter(d adapter) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(adapter != null ? adapter.asBinder() : null);
                    this.le.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.h addCircle(CircleOptions options) throws RemoteException {
                com.google.android.gms.maps.model.internal.h h2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    h2 = h.a.bw(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return h2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMyLocationChangeListener(q listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMyLocationButtonClickListener(p listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void snapshot(v callback, com.google.android.gms.dynamic.d bitmap) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    parcel.writeStrongBinder(bitmap != null ? bitmap.asBinder() : null);
                    this.le.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPadding(int left, int top, int right, int bottom) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(left);
                    parcel.writeInt(top);
                    parcel.writeInt(right);
                    parcel.writeInt(bottom);
                    this.le.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBuildingsEnabled() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBuildingsEnabled(boolean enabled) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeInt(enabled ? 1 : 0);
                    this.le.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnMapLoadedCallback(k callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.le.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.j getFocusedBuilding() throws RemoteException {
                com.google.android.gms.maps.model.internal.j j2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    j2 = j.a.by(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return j2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOnIndoorStateChangeListener(g listener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.le.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getMapAsync(m callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.le.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreate(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResume() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPause() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDestroy() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLowMemory() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean useViewLifecycleWhenInFragment() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    this.le.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSaveInstanceState(Bundle outState) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (outState != null) {
                        parcel.writeInt(1);
                        outState.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    if (0 != parcel2.readInt()) {
                        outState.readFromParcel(parcel2);
                    }
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setContentDescription(String description) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeString(description);
                    this.le.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveCamera2(c update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (update != null) {
                        parcel.writeInt(1);
                        update.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCamera2(c update) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (update != null) {
                        parcel.writeInt(1);
                        update.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(65, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithCallback2(c update, b callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (update != null) {
                        parcel.writeInt(1);
                        update.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.le.transact(66, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateCameraWithDurationAndCallback2(c update, int durationMs, b callback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (update != null) {
                        parcel.writeInt(1);
                        update.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(durationMs);
                    parcel.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.le.transact(67, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public com.google.android.gms.maps.model.internal.l addMarker2(MarkerOptions options, com.google.android.gms.maps.model.internal.p parcelableOptions) throws RemoteException {
                com.google.android.gms.maps.model.internal.l l2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (parcelableOptions != null) {
                        parcel.writeInt(1);
                        parcelableOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(68, parcel, parcel2, 0);
                    parcel2.readException();
                    l2 = l.a.bA(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return l2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInfoWindowRenderer(e infoWindowRenderer) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    parcel.writeStrongBinder(infoWindowRenderer != null ? infoWindowRenderer.asBinder() : null);
                    this.le.transact(69, parcel, parcel2, 0);
                    parcel2.readException();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public i addGroundOverlay2(GroundOverlayOptions options, com.google.android.gms.maps.model.internal.e parcelableOptions) throws RemoteException {
                i i2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.IGoogleMapDelegate");
                    if (options != null) {
                        parcel.writeInt(1);
                        options.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (parcelableOptions != null) {
                        parcel.writeInt(1);
                        parcelableOptions.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.le.transact(70, parcel, parcel2, 0);
                    parcel2.readException();
                    i2 = i.a.bx(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return i2;
            }
        }
    }
}

