/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.zzor;
import com.google.android.gms.internal.zzos;

public class zzoq
extends zzk<zzos> {
    private Activity zzoi;
    private zza zzalt;
    private final String zzHg;
    private final int mTheme;

    public zzoq(Activity activity, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, int n) {
        super((Context)activity, looper, 12, connectionCallbacks, onConnectionFailedListener);
        this.zzHg = string;
        this.zzoi = activity;
        this.mTheme = n;
    }

    protected String zzcF() {
        return "com.google.android.gms.identity.service.BIND";
    }

    protected String zzcG() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    protected zzos zzbd(IBinder iBinder) {
        return zzos.zza.zzbf(iBinder);
    }

    public void disconnect() {
        super.disconnect();
        if (this.zzalt != null) {
            this.zzalt.setActivity(null);
            this.zzalt = null;
        }
    }

    protected zzos zzpm() throws DeadObjectException {
        return (zzos)super.zzjb();
    }

    protected void zzpn() {
        super.zzfc();
    }

    public void zza(UserAddressRequest userAddressRequest, int n) {
        this.zzpn();
        this.zzalt = new zza(n, this.zzoi);
        try {
            Bundle bundle = new Bundle();
            String string = this.getContext().getPackageName();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", string);
            if (!TextUtils.isEmpty((CharSequence)this.zzHg)) {
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)new Account(this.zzHg, "com.google"));
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.mTheme);
            this.zzpm().zza(this.zzalt, userAddressRequest, bundle);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            this.zzalt.zzi(1, bundle);
        }
    }

    protected /* synthetic */ IInterface zzp(IBinder iBinder) {
        return this.zzbd(iBinder);
    }

    public static final class zza
    extends zzor.zza {
        private final int zzPu;
        private Activity zzoi;

        public zza(int n, Activity activity) {
            this.zzPu = n;
            this.zzoi = activity;
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            ConnectionResult connectionResult;
            if (n == 1) {
                Intent intent = new Intent();
                intent.putExtras(bundle);
                PendingIntent pendingIntent = this.zzoi.createPendingResult(this.zzPu, intent, 0x40000000);
                if (pendingIntent == null) {
                    return;
                }
                try {
                    pendingIntent.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception settng pending result", (Throwable)canceledException);
                }
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.identity.intents.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(this.zzoi, this.zzPu);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                try {
                    PendingIntent pendingIntent2 = this.zzoi.createPendingResult(this.zzPu, new Intent(), 0x40000000);
                    if (pendingIntent2 != null) {
                        pendingIntent2.send(1);
                    }
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        private void setActivity(Activity activity) {
            this.zzoi = activity;
        }
    }
}

