/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zza;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;

public class zzd {
    SharedPreferences zzaxq;
    Context zzpH;

    public zzd(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    public zzd(Context context, String string) {
        this.zzpH = context;
        this.zzaxq = context.getSharedPreferences(string, 4);
        this.zzde(string + "-no-backup");
    }

    private void zzde(String string) {
        block4: {
            File file = new ContextCompat().getNoBackupFilesDir(this.zzpH);
            File file2 = new File(file, string);
            if (file2.exists()) {
                return;
            }
            try {
                if (file2.createNewFile() && !this.isEmpty()) {
                    Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                    InstanceIDListenerService.zza(this.zzpH, this);
                }
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                Log.d((String)"InstanceID/Store", (String)("Error creating file in no backup dir: " + iOException.getMessage()));
            }
        }
    }

    boolean isEmpty() {
        return this.zzaxq.getAll().isEmpty();
    }

    private String zzf(String string, String string2, String string3) {
        return string + "|T|" + string2 + "|" + string3;
    }

    synchronized String get(String subtype, String key) {
        return this.zzaxq.getString(subtype + "|S|" + key, null);
    }

    synchronized String get(String key) {
        return this.zzaxq.getString(key, null);
    }

    public synchronized void zzdf(String string) {
        SharedPreferences.Editor editor = this.zzaxq.edit();
        Map map = this.zzaxq.getAll();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            editor.remove(string2);
        }
        editor.commit();
    }

    public synchronized void zzul() {
        this.zzaxq.edit().clear().commit();
    }

    public synchronized String zzg(String string, String string2, String string3) {
        String string4 = this.zzf(string, string2, string3);
        String string5 = this.zzaxq.getString(string4, null);
        return string5;
    }

    public synchronized void zza(String string, String string2, String string3, String string4, String string5) {
        String string6 = this.zzf(string, string2, string3);
        SharedPreferences.Editor editor = this.zzaxq.edit();
        editor.putString(string6, string4);
        editor.putString("appVersion", string5);
        editor.putString("lastToken", Long.toString(System.currentTimeMillis() / 1000L));
        editor.commit();
    }

    public synchronized void zzh(String string, String string2, String string3) {
        String string4 = this.zzf(string, string2, string3);
        SharedPreferences.Editor editor = this.zzaxq.edit();
        editor.remove(string4);
        editor.commit();
    }

    public KeyPair zzdg(String string) {
        return this.zzdj(string);
    }

    synchronized KeyPair zze(String string, long l) {
        KeyPair keyPair = zza.zzud();
        this.zzaxq.edit().putString(string + "|P|", InstanceID.zzm(keyPair.getPublic().getEncoded())).putString(string + "|K|", InstanceID.zzm(keyPair.getPrivate().getEncoded())).putString(string + "|S|" + "cre", Long.toString(l)).commit();
        return keyPair;
    }

    void zzdh(String string) {
        this.zzdf(string + "|");
    }

    public void zzdi(String string) {
        this.zzdf(string + "|T|");
    }

    KeyPair zzdj(String string) {
        String string2 = this.get(string, "|P|");
        String string3 = this.get(string, "|K|");
        if (string3 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string2, (int)8);
            byte[] byArray2 = Base64.decode((String)string3, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            Log.w((String)"InstanceID/Store", (String)("Invalid key stored " + generalSecurityException));
            InstanceIDListenerService.zza(this.zzpH, this);
            return null;
        }
    }
}

