/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;

class zza {
    static zza zzavF;
    private Context mContext;

    static synchronized zza zzar(Context context) {
        if (zzavF == null) {
            zzavF = new zza(context);
        }
        return zzavF;
    }

    static boolean zzt(Bundle bundle) {
        return zza.zzb(bundle, "gcm.n.title") != null;
    }

    static String zzb(Bundle bundle, String string) {
        String string2 = bundle.getString(string);
        if (string2 == null) {
            string2 = bundle.getString(string.replace("gcm.n.", "gcm.notification."));
        }
        return string2;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    boolean zzu(Bundle bundle) {
        try {
            Notification notification = this.zzv(bundle);
            this.zza(zza.zzb(bundle, "gcm.n.tag"), notification);
            return true;
        }
        catch (zza zza2) {
            Log.w((String)"GcmNotification", (String)("Failed to show notification: " + zza2.getMessage()));
            return false;
        }
    }

    private Notification zzv(Bundle bundle) {
        Notification notification;
        String string = zza.zzb(bundle, "gcm.n.title");
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new zza("Missing title");
        }
        String string2 = zza.zzb(bundle, "gcm.n.body");
        int n = this.zzda(zza.zzb(bundle, "gcm.n.icon"));
        Uri uri = this.zzdb(zza.zzb(bundle, "gcm.n.sound"));
        PendingIntent pendingIntent = this.zzw(bundle);
        if (Build.VERSION.SDK_INT >= 11) {
            String string3;
            Notification.Builder builder = new Notification.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n).setContentTitle((CharSequence)string).setContentText((CharSequence)string2);
            if (Build.VERSION.SDK_INT >= 21 && !TextUtils.isEmpty((CharSequence)(string3 = zza.zzb(bundle, "gcm.n.color")))) {
                builder.setColor(Color.parseColor((String)string3));
            }
            if (uri != null) {
                builder.setSound(uri);
            }
            if (pendingIntent != null) {
                builder.setContentIntent(pendingIntent);
            }
            notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
        } else {
            notification = new Notification();
            notification.flags |= 0x10;
            notification.icon = n;
            if (uri != null) {
                notification.sound = uri;
            }
            if (pendingIntent == null) {
                Intent intent = new Intent();
                intent.setPackage("com.google.example.invalidpackage");
                pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            }
            notification.setLatestEventInfo(this.mContext, (CharSequence)string, (CharSequence)string2, pendingIntent);
        }
        return notification;
    }

    private void zza(String string, Notification notification) {
        if (Log.isLoggable((String)"GcmNotification", (int)3)) {
            Log.d((String)"GcmNotification", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "GCM-Notification:" + SystemClock.uptimeMillis();
        }
        notificationManager.notify(string, 0, notification);
    }

    private int zzda(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new zza("Missing icon");
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string, "drawable", this.mContext.getPackageName());
        if (n != 0) {
            return n;
        }
        n = resources.getIdentifier(string, "mipmap", this.mContext.getPackageName());
        if (n != 0) {
            return n;
        }
        throw new zza("Icon resource not found: " + string);
    }

    private Uri zzdb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if ("default".equals(string)) {
            return RingtoneManager.getDefaultUri((int)2);
        }
        throw new zza("Invalid sound: " + string);
    }

    private PendingIntent zzw(Bundle bundle) {
        String string = zza.zzb(bundle, "gcm.n.click_action");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Intent intent = new Intent(string);
        intent.setPackage(this.mContext.getPackageName());
        intent.setFlags(0x10000000);
        intent.putExtras(bundle);
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("gcm.n.") && !string2.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string2);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x40000000);
    }

    private class zza
    extends IllegalArgumentException {
        private zza(String string) {
            super(string);
        }
    }
}

