/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
implements SafeParcelable,
Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new MilestoneEntityCreator();
    private final int zzCY;
    private final String zzapR;
    private final long zzauS;
    private final long zzauT;
    private final byte[] zzauU;
    private final int mState;
    private final String zzaoK;

    public MilestoneEntity(Milestone milestone) {
        this.zzCY = 4;
        this.zzapR = milestone.getMilestoneId();
        this.zzauS = milestone.getCurrentProgress();
        this.zzauT = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.zzaoK = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.zzauU = null;
        } else {
            this.zzauU = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzauU, 0, byArray.length);
        }
    }

    MilestoneEntity(int versionCode, String milestoneId, long currentProgress, long targetProgress, byte[] completionBlob, int state, String eventId) {
        this.zzCY = versionCode;
        this.zzapR = milestoneId;
        this.zzauS = currentProgress;
        this.zzauT = targetProgress;
        this.zzauU = completionBlob;
        this.mState = state;
        this.zzaoK = eventId;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getEventId() {
        return this.zzaoK;
    }

    @Override
    public String getMilestoneId() {
        return this.zzapR;
    }

    @Override
    public long getCurrentProgress() {
        return this.zzauS;
    }

    @Override
    public long getTargetProgress() {
        return this.zzauT;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.zzauU;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzt.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object obj) {
        return MilestoneEntity.zza(this, obj);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzt.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzt.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzt.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzt.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzt.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzt.zzt((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        MilestoneEntityCreator.zza(this, out, flags);
    }
}

