/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zzlc;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int zzCY;
    private final String zzaoK;
    private final String mName;
    private final String zzakM;
    private final Uri zzanf;
    private final String zzanq;
    private final PlayerEntity zzaog;
    private final long zzaoL;
    private final String zzaoM;
    private final boolean zzaoN;

    public EventEntity(Event event) {
        this.zzCY = 1;
        this.zzaoK = event.getEventId();
        this.mName = event.getName();
        this.zzakM = event.getDescription();
        this.zzanf = event.getIconImageUri();
        this.zzanq = event.getIconImageUrl();
        this.zzaog = (PlayerEntity)event.getPlayer().freeze();
        this.zzaoL = event.getValue();
        this.zzaoM = event.getFormattedValue();
        this.zzaoN = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.zzCY = versionCode;
        this.zzaoK = eventId;
        this.mName = name;
        this.zzakM = description;
        this.zzanf = iconImageUri;
        this.zzanq = iconImageUrl;
        this.zzaog = new PlayerEntity(player);
        this.zzaoL = value;
        this.zzaoM = formattedValue;
        this.zzaoN = isVisible;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getEventId() {
        return this.zzaoK;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzakM, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzanf;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzanq;
    }

    @Override
    public Player getPlayer() {
        return this.zzaog;
    }

    @Override
    public long getValue() {
        return this.zzaoL;
    }

    @Override
    public String getFormattedValue() {
        return this.zzaoM;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzaoM, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzaoN;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzt.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzt.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzt.equal((Object)event2.getName(), (Object)event.getName()) && zzt.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzt.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzt.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzt.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzt.equal((Object)event2.getValue(), (Object)event.getValue()) && zzt.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzt.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzt.zzt((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

