/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int zzFG;
    private final GameEntity zzahV;
    private final PlayerEntity zzakx;
    private final byte[] zzakd;
    private final String zzxv;
    private final ArrayList<PlayerEntity> zzaky;
    private final int zzJp;
    private final long zzajw;
    private final long zzakz;
    private final Bundle zzakA;
    private final int zzrX;

    public GameRequestEntity(GameRequest request) {
        this.zzFG = 2;
        this.zzahV = new GameEntity(request.getGame());
        this.zzakx = new PlayerEntity(request.getSender());
        this.zzxv = request.getRequestId();
        this.zzJp = request.getType();
        this.zzajw = request.getCreationTimestamp();
        this.zzakz = request.getExpirationTimestamp();
        this.zzrX = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.zzakd = null;
        } else {
            this.zzakd = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzakd, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n = list.size();
        this.zzaky = new ArrayList(n);
        this.zzakA = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzaky.add((PlayerEntity)player);
            this.zzakA.putInt(string, request.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.zzFG = versionCode;
        this.zzahV = game;
        this.zzakx = sender;
        this.zzakd = data;
        this.zzxv = requestId;
        this.zzaky = recipients;
        this.zzJp = type;
        this.zzajw = creationTimestamp;
        this.zzakz = expirationTimestamp;
        this.zzakA = recipientStatuses;
        this.zzrX = status;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public String getRequestId() {
        return this.zzxv;
    }

    @Override
    public Game getGame() {
        return this.zzahV;
    }

    @Override
    public Player getSender() {
        return this.zzakx;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzaky);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzakd;
    }

    @Override
    public int getType() {
        return this.zzJp;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzajw;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzakz;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.zzakA.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.zzrX;
    }

    public Bundle zzpb() {
        return this.zzakA;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzw.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzw.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzw.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzw.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzw.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzw.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzw.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzw.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzw.zzk((Object)gameRequest).zza("Game", (Object)gameRequest.getGame()).zza("Sender", (Object)gameRequest.getSender()).zza("Recipients", gameRequest.getRecipients()).zza("Data", (Object)gameRequest.getData()).zza("RequestId", (Object)gameRequest.getRequestId()).zza("Type", (Object)gameRequest.getType()).zza("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zza("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.zza(this, dest, flags);
    }
}

