/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneRef;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntity;
import java.util.ArrayList;
import java.util.List;

public final class QuestRef
extends zzd
implements Quest {
    private final Game zzaiU;
    private final int zzadF;

    QuestRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.zzaiU = new GameRef(holder, dataRow);
        this.zzadF = numChildren;
    }

    @Override
    public String getQuestId() {
        return this.getString("external_quest_id");
    }

    @Override
    public String getName() {
        return this.getString("quest_name");
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        this.zza("quest_name", dataOut);
    }

    @Override
    public String getDescription() {
        return this.getString("quest_description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.zza("quest_description", dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzbb("quest_icon_image_uri");
    }

    @Override
    public String getIconImageUrl() {
        return this.getString("quest_icon_image_url");
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzbb("quest_banner_image_uri");
    }

    @Override
    public String getBannerImageUrl() {
        return this.getString("quest_banner_image_url");
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzoZ().get(0);
    }

    @Override
    public List<Milestone> zzoZ() {
        ArrayList<Milestone> arrayList = new ArrayList<Milestone>(this.zzadF);
        for (int i = 0; i < this.zzadF; ++i) {
            arrayList.add(new MilestoneRef(this.zzMd, this.zzNQ + i));
        }
        return arrayList;
    }

    @Override
    public Game getGame() {
        return this.zzaiU;
    }

    @Override
    public int getState() {
        return this.getInteger("quest_state");
    }

    @Override
    public int getType() {
        return this.getInteger("quest_type");
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.getLong("accepted_ts");
    }

    @Override
    public long getEndTimestamp() {
        return this.getLong("quest_end_ts");
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.getLong("quest_last_updated_ts");
    }

    @Override
    public long zzpa() {
        return this.getLong("notification_ts");
    }

    @Override
    public long getStartTimestamp() {
        return this.getLong("quest_start_ts");
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzpa() <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return new QuestEntity(this);
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    public boolean equals(Object obj) {
        return QuestEntity.zza(this, obj);
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        QuestEntity questEntity = (QuestEntity)this.freeze();
        questEntity.writeToParcel(dest, flags);
    }
}

