/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.zzlw;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final QuestEntityCreator CREATOR = new QuestEntityCreator();
    private final int zzFG;
    private final GameEntity zzahV;
    private final String zzakn;
    private final long zzako;
    private final Uri zzakp;
    private final String zzakq;
    private final String zzZO;
    private final long zzakr;
    private final long zzadi;
    private final Uri zzaks;
    private final String zzakt;
    private final String mName;
    private final long zzaku;
    private final long zzakv;
    private final int mState;
    private final int zzJp;
    private final ArrayList<MilestoneEntity> zzakw;

    public QuestEntity(Quest quest) {
        this.zzFG = 2;
        this.zzahV = new GameEntity(quest.getGame());
        this.zzakn = quest.getQuestId();
        this.zzako = quest.getAcceptedTimestamp();
        this.zzZO = quest.getDescription();
        this.zzakp = quest.getBannerImageUri();
        this.zzakq = quest.getBannerImageUrl();
        this.zzakr = quest.getEndTimestamp();
        this.zzaks = quest.getIconImageUri();
        this.zzakt = quest.getIconImageUrl();
        this.zzadi = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzaku = quest.zzpa();
        this.zzakv = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzJp = quest.getType();
        List<Milestone> list = quest.zzoZ();
        int n = list.size();
        this.zzakw = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzakw.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.zzFG = versionCode;
        this.zzahV = game;
        this.zzakn = questId;
        this.zzako = acceptedTimestamp;
        this.zzakp = bannerImageUri;
        this.zzakq = bannerImageUrl;
        this.zzZO = description;
        this.zzakr = endTimestamp;
        this.zzadi = lastUpdatedTimestamp;
        this.zzaks = iconImageUri;
        this.zzakt = iconImageUrl;
        this.mName = name;
        this.zzaku = notifyTimestamp;
        this.zzakv = startTimestamp;
        this.mState = state;
        this.zzJp = type;
        this.zzakw = milestones;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public String getQuestId() {
        return this.zzakn;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzZO, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaks;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzakt;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzakp;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzakq;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzoZ().get(0);
    }

    @Override
    public List<Milestone> zzoZ() {
        return new ArrayList<Milestone>(this.zzakw);
    }

    @Override
    public Game getGame() {
        return this.zzahV;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzJp;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzako;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzakr;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzadi;
    }

    @Override
    public long zzpa() {
        return this.zzaku;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzakv;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzaku <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzw.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzoZ(), quest.getName(), quest.zzpa(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object obj) {
        return QuestEntity.zza(this, obj);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzw.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzw.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzw.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzw.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzw.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzw.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzw.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzw.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzw.equal(quest2.zzoZ(), quest.zzoZ()) && zzw.equal((Object)quest2.getName(), (Object)quest.getName()) && zzw.equal((Object)quest2.zzpa(), (Object)quest.zzpa()) && zzw.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzw.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzw.zzk((Object)quest).zza("Game", (Object)quest.getGame()).zza("QuestId", (Object)quest.getQuestId()).zza("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zza("BannerImageUri", (Object)quest.getBannerImageUri()).zza("BannerImageUrl", (Object)quest.getBannerImageUrl()).zza("Description", (Object)quest.getDescription()).zza("EndTimestamp", (Object)quest.getEndTimestamp()).zza("IconImageUri", (Object)quest.getIconImageUri()).zza("IconImageUrl", (Object)quest.getIconImageUrl()).zza("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zza("Milestones", quest.zzoZ()).zza("Name", (Object)quest.getName()).zza("NotifyTimestamp", (Object)quest.zzpa()).zza("StartTimestamp", (Object)quest.getStartTimestamp()).zza("State", (Object)quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.zza(this, out, flags);
    }
}

