/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.zzlw;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int zzFG;
    private final String zzaem;
    private final String zzajS;
    private final long zzajw;
    private final int zzajT;
    private final String zzZO;
    private final int zzajA;
    private final Bundle zzajQ;
    private final ArrayList<ParticipantEntity> zzajz;
    private final int zzajU;

    public RoomEntity(Room room) {
        this.zzFG = 2;
        this.zzaem = room.getRoomId();
        this.zzajS = room.getCreatorId();
        this.zzajw = room.getCreationTimestamp();
        this.zzajT = room.getStatus();
        this.zzZO = room.getDescription();
        this.zzajA = room.getVariant();
        this.zzajQ = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzajz = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzajz.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzajU = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.zzFG = versionCode;
        this.zzaem = roomId;
        this.zzajS = creatorId;
        this.zzajw = creationTimestamp;
        this.zzajT = roomStatus;
        this.zzZO = description;
        this.zzajA = variant;
        this.zzajQ = autoMatchCriteria;
        this.zzajz = participants;
        this.zzajU = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public String getRoomId() {
        return this.zzaem;
    }

    @Override
    public String getCreatorId() {
        return this.zzajS;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzajw;
    }

    @Override
    public int getStatus() {
        return this.zzajT;
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzZO, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzajA;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzajQ;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzajz);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.zzajU;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.zza((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.zzc(this, participantId);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzw.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object obj) {
        return RoomEntity.zza((Room)this, obj);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzw.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzw.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzw.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzw.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzw.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzw.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzw.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzw.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzw.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzw.zzk((Object)room).zza("RoomId", (Object)room.getRoomId()).zza("CreatorId", (Object)room.getCreatorId()).zza("CreationTimestamp", (Object)room.getCreationTimestamp()).zza("RoomStatus", (Object)room.getStatus()).zza("Description", (Object)room.getDescription()).zza("Variant", (Object)room.getVariant()).zza("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zza("Participants", (Object)room.getParticipants()).zza("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zziY()) {
            RoomEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzaem);
            dest.writeString(this.zzajS);
            dest.writeLong(this.zzajw);
            dest.writeInt(this.zzajT);
            dest.writeString(this.zzZO);
            dest.writeInt(this.zzajA);
            dest.writeBundle(this.zzajQ);
            int n = this.zzajz.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzajz.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzdh(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.zzd(RoomEntity.zziX());
            if (bl || RoomEntity.zzbf((String)RoomEntity.class.getCanonicalName())) {
                return super.zzdh(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, n);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdh(x0);
        }
    }
}

