/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int zzFG;
    private final GameEntity zzahV;
    private final String zzaek;
    private final long zzajw;
    private final int zzajx;
    private final ParticipantEntity zzajy;
    private final ArrayList<ParticipantEntity> zzajz;
    private final int zzajA;
    private final int zzajB;

    InvitationEntity(Invitation invitation) {
        this.zzFG = 2;
        this.zzahV = new GameEntity(invitation.getGame());
        this.zzaek = invitation.getInvitationId();
        this.zzajw = invitation.getCreationTimestamp();
        this.zzajx = invitation.getInvitationType();
        this.zzajA = invitation.getVariant();
        this.zzajB = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzajz = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzajz.add((ParticipantEntity)participant2.freeze());
        }
        zzx.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzajy = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.zzFG = versionCode;
        this.zzahV = game;
        this.zzaek = invitationId;
        this.zzajw = creationTimestamp;
        this.zzajx = invitationType;
        this.zzajy = inviter;
        this.zzajz = participants;
        this.zzajA = variant;
        this.zzajB = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public Game getGame() {
        return this.zzahV;
    }

    @Override
    public String getInvitationId() {
        return this.zzaek;
    }

    @Override
    public Participant getInviter() {
        return this.zzajy;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzajw;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzajz);
    }

    @Override
    public int getInvitationType() {
        return this.zzajx;
    }

    @Override
    public int getVariant() {
        return this.zzajA;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.zzajB;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzw.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object obj) {
        return InvitationEntity.zza(this, obj);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzw.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzw.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzw.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzw.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzw.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzw.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzw.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzw.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzw.zzk((Object)invitation).zza("Game", (Object)invitation.getGame()).zza("InvitationId", (Object)invitation.getInvitationId()).zza("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zza("InvitationType", (Object)invitation.getInvitationType()).zza("Inviter", (Object)invitation.getInviter()).zza("Participants", (Object)invitation.getParticipants()).zza("Variant", (Object)invitation.getVariant()).zza("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zziY()) {
            InvitationEntityCreator.zza(this, dest, flags);
        } else {
            this.zzahV.writeToParcel(dest, flags);
            dest.writeString(this.zzaek);
            dest.writeLong(this.zzajw);
            dest.writeInt(this.zzajx);
            this.zzajy.writeToParcel(dest, flags);
            int n = this.zzajz.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzajz.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzde(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzd(InvitationEntity.zziX());
            if (bl || InvitationEntity.zzbf((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzde(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            int n4 = 0;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, n, n4);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzde(x0);
        }
    }
}

