/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.TimeSpan;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] zzaiP = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String zzaiR;
    private String zzacH;
    private int zzLs;
    private HashMap<Integer, Result> zzajv;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.zzLs = dataHolder.getStatusCode();
        this.zzajv = new HashMap();
        int n = dataHolder.getCount();
        zzx.zzO((n == 3 ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = dataHolder.zzax(i);
            if (i == 0) {
                this.zzaiR = dataHolder.zzc("leaderboardId", i, n2);
                this.zzacH = dataHolder.zzc("playerId", i, n2);
            }
            if (!(bl = dataHolder.zzd("hasResult", i, n2))) continue;
            Result result = new Result(dataHolder.zza("rawScore", i, n2), dataHolder.zzc("formattedScore", i, n2), dataHolder.zzc("scoreTag", i, n2), dataHolder.zzd("newBest", i, n2));
            this.zza(result, dataHolder.zzb("timeSpan", i, n2));
        }
    }

    public String getLeaderboardId() {
        return this.zzaiR;
    }

    public String getPlayerId() {
        return this.zzacH;
    }

    public Result getScoreResult(int timeSpan) {
        return this.zzajv.get(timeSpan);
    }

    private void zza(Result result, int n) {
        this.zzajv.put(n, result);
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzk((Object)this).zza("PlayerId", (Object)this.zzacH).zza("StatusCode", (Object)this.zzLs);
        for (int i = 0; i < 3; ++i) {
            Result result = this.zzajv.get(i);
            zza2.zza("TimesSpan", (Object)TimeSpan.zzeJ(i));
            zza2.zza("Result", (Object)(result == null ? "null" : result.toString()));
        }
        return zza2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return zzw.zzk((Object)this).zza("RawScore", (Object)this.rawScore).zza("FormattedScore", (Object)this.formattedScore).zza("ScoreTag", (Object)this.scoreTag).zza("NewBest", (Object)this.newBest).toString();
        }
    }
}

