/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.zzlw;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzaiW;
    private final String zzaiX;
    private final String zzaiY;
    private final long zzaiZ;
    private final long zzaja;
    private final String zzajb;
    private final Uri zzajc;
    private final Uri zzajd;
    private final PlayerEntity zzaje;
    private final String zzajf;
    private final String zzajg;
    private final String zzajh;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.zzaiW = score.getRank();
        this.zzaiX = (String)zzx.zzl((Object)score.getDisplayRank());
        this.zzaiY = (String)zzx.zzl((Object)score.getDisplayScore());
        this.zzaiZ = score.getRawScore();
        this.zzaja = score.getTimestampMillis();
        this.zzajb = score.getScoreHolderDisplayName();
        this.zzajc = score.getScoreHolderIconImageUri();
        this.zzajd = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.zzaje = player == null ? null : (PlayerEntity)player.freeze();
        this.zzajf = score.getScoreTag();
        this.zzajg = score.getScoreHolderIconImageUrl();
        this.zzajh = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzaiW;
    }

    @Override
    public String getDisplayRank() {
        return this.zzaiX;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzaiX, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.zzaiY;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzaiY, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getRawScore() {
        return this.zzaiZ;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzaja;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzaje == null) {
            return this.zzajb;
        }
        return this.zzaje.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaje == null) {
            zzlw.zzb((String)this.zzajb, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzaje.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzaje == null) {
            return this.zzajc;
        }
        return this.zzaje.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzaje == null) {
            return this.zzajg;
        }
        return this.zzaje.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzaje == null) {
            return this.zzajd;
        }
        return this.zzaje.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzaje == null) {
            return this.zzajh;
        }
        return this.zzaje.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzaje;
    }

    @Override
    public String getScoreTag() {
        return this.zzajf;
    }

    public LeaderboardScore zzoS() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzw.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzw.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzw.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzw.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzw.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzw.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzw.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzw.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzw.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzw.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzw.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzw.zzk((Object)leaderboardScore).zza("Rank", (Object)leaderboardScore.getRank()).zza("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zza("Score", (Object)leaderboardScore.getRawScore()).zza("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zza("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zza("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zza("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zza("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zza("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zza("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zza("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zza("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzoS();
    }
}

