/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.RequestUpdateResultOutcome;
import java.util.HashMap;
import java.util.Set;

public final class RequestUpdateOutcomes {
    private static final String[] zzaiP = new String[]{"requestId", "outcome"};
    private final int zzLs;
    private final HashMap<String, Integer> zzaiQ;

    private RequestUpdateOutcomes(int statusCode, HashMap<String, Integer> outcomeMap) {
        this.zzLs = statusCode;
        this.zzaiQ = outcomeMap;
    }

    public int getRequestOutcome(String requestId) {
        zzx.zzb((boolean)this.zzaiQ.containsKey(requestId), (Object)("Request " + requestId + " was not part of the update operation!"));
        return this.zzaiQ.get(requestId);
    }

    public Set<String> getRequestIds() {
        return this.zzaiQ.keySet();
    }

    public static RequestUpdateOutcomes zzW(DataHolder dataHolder) {
        Builder builder = new Builder();
        builder.zzeU(dataHolder.getStatusCode());
        int n = dataHolder.getCount();
        for (int i = 0; i < n; ++i) {
            int n2 = dataHolder.zzax(i);
            builder.zzA(dataHolder.zzc("requestId", i, n2), dataHolder.zzb("outcome", i, n2));
        }
        return builder.zzoO();
    }

    public static final class Builder {
        private HashMap<String, Integer> zzaiQ = new HashMap();
        private int zzLs = 0;

        public Builder zzA(String string, int n) {
            if (RequestUpdateResultOutcome.isValid(n)) {
                this.zzaiQ.put(string, n);
            }
            return this;
        }

        public Builder zzeU(int n) {
            this.zzLs = n;
            return this;
        }

        public RequestUpdateOutcomes zzoO() {
            return new RequestUpdateOutcomes(this.zzLs, this.zzaiQ);
        }
    }
}

