/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zze;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;

public final class QuestsImpl
implements Quests {
    @Override
    public Intent getQuestsIntent(GoogleApiClient apiClient, int[] questSelectors) {
        return Games.zzd(apiClient).zzb(questSelectors);
    }

    @Override
    public Intent getQuestIntent(GoogleApiClient apiClient, String questId) {
        return Games.zzd(apiClient).zzbP(questId);
    }

    @Override
    public void registerQuestUpdateListener(GoogleApiClient apiClient, QuestUpdateListener listener) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            zze zze2 = apiClient.zzf((Object)listener);
            gamesClientImpl.zzc((zze<QuestUpdateListener>)zze2);
        }
    }

    @Override
    public void unregisterQuestUpdateListener(GoogleApiClient apiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zznz();
        }
    }

    @Override
    public PendingResult<Quests.AcceptQuestResult> accept(GoogleApiClient apiClient, final String questId) {
        return apiClient.zzb((zza.zza)new AcceptImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzh((zza.zzb<Quests.AcceptQuestResult>)this, questId);
            }
        });
    }

    @Override
    public PendingResult<Quests.ClaimMilestoneResult> claim(GoogleApiClient apiClient, final String questId, final String milestoneId) {
        return apiClient.zzb((zza.zza)new ClaimImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zza.zzb<Quests.ClaimMilestoneResult>)this, questId, milestoneId);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> load(GoogleApiClient apiClient, final int[] questSelectors, final int sortOrder, final boolean forceReload) {
        return apiClient.zza((zza.zza)new LoadsImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zza.zzb<Quests.LoadQuestsResult>)this, questSelectors, sortOrder, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> loadByIds(GoogleApiClient apiClient, final boolean forceReload, final String ... questIds) {
        return apiClient.zza((zza.zza)new LoadsImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zza.zzb<Quests.LoadQuestsResult>)this, forceReload, questIds);
            }
        });
    }

    @Override
    public void showStateChangedPopup(GoogleApiClient apiClient, String questId) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzbQ(questId);
        }
    }

    private static abstract class LoadsImpl
    extends Games.BaseGamesApiMethodImpl<Quests.LoadQuestsResult> {
        private LoadsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.LoadQuestsResult zzai(final Status status) {
            return new Quests.LoadQuestsResult(){

                public void release() {
                }

                public Status getStatus() {
                    return status;
                }

                @Override
                public QuestBuffer getQuests() {
                    int n = status.getStatusCode();
                    return new QuestBuffer(DataHolder.zzay((int)n));
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzai(x0);
        }
    }

    private static abstract class ClaimImpl
    extends Games.BaseGamesApiMethodImpl<Quests.ClaimMilestoneResult> {
        private ClaimImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.ClaimMilestoneResult zzah(final Status status) {
            return new Quests.ClaimMilestoneResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Milestone getMilestone() {
                    return null;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzah(x0);
        }
    }

    private static abstract class AcceptImpl
    extends Games.BaseGamesApiMethodImpl<Quests.AcceptQuestResult> {
        private AcceptImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.AcceptQuestResult zzag(final Status status) {
            return new Quests.AcceptQuestResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzag(x0);
        }
    }
}

