/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.zzlw;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int zzFG;
    private final String zzacH;
    private final String zzSJ;
    private final Uri zzacc;
    private final Uri zzacd;
    private final long zzacI;
    private final int zzacJ;
    private final long zzacK;
    private final String zzacn;
    private final String zzaco;
    private final String zzSy;
    private final MostRecentGameInfoEntity zzacL;
    private final PlayerLevelInfo zzacM;
    private final boolean zzacN;
    private final boolean zzacO;

    public PlayerEntity(Player player) {
        this.zzFG = 12;
        this.zzacH = player.getPlayerId();
        this.zzSJ = player.getDisplayName();
        this.zzacc = player.getIconImageUri();
        this.zzacn = player.getIconImageUrl();
        this.zzacd = player.getHiResImageUri();
        this.zzaco = player.getHiResImageUrl();
        this.zzacI = player.getRetrievedTimestamp();
        this.zzacJ = player.zzmE();
        this.zzacK = player.getLastPlayedWithTimestamp();
        this.zzSy = player.getTitle();
        this.zzacN = player.isProfileVisible();
        MostRecentGameInfo mostRecentGameInfo = player.zzmF();
        this.zzacL = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzacM = player.getLevelInfo();
        this.zzacO = player.zzmD();
        zzb.zzh((Object)this.zzacH);
        zzb.zzh((Object)this.zzSJ);
        zzb.zzN((this.zzacI > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible, boolean hasDebugAccess) {
        this.zzFG = versionCode;
        this.zzacH = playerId;
        this.zzSJ = displayName;
        this.zzacc = iconImageUri;
        this.zzacn = iconImageUrl;
        this.zzacd = hiResImageUri;
        this.zzaco = hiResImageUrl;
        this.zzacI = retrievedTimestamp;
        this.zzacJ = isInCircles;
        this.zzacK = lastPlayedWithTimestamp;
        this.zzSy = title;
        this.zzacN = isProfileVisible;
        this.zzacL = mostRecentGameInfo;
        this.zzacM = playerLevelInfo;
        this.zzacO = hasDebugAccess;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public String getPlayerId() {
        return this.zzacH;
    }

    @Override
    public String getDisplayName() {
        return this.zzSJ;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzSJ, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean zzmD() {
        return this.zzacO;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzacc;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzacn;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzacd;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzaco;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzacI;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzacK;
    }

    @Override
    public int zzmE() {
        return this.zzacJ;
    }

    @Override
    public boolean isProfileVisible() {
        return this.zzacN;
    }

    @Override
    public String getTitle() {
        return this.zzSy;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzSy, (CharArrayBuffer)dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzacM;
    }

    @Override
    public MostRecentGameInfo zzmF() {
        return this.zzacL;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzw.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzmD(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo()});
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzw.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzw.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzw.equal((Object)player2.zzmD(), (Object)player.zzmD()) && zzw.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzw.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzw.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzw.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzw.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzw.zzk((Object)player).zza("PlayerId", (Object)player.getPlayerId()).zza("DisplayName", (Object)player.getDisplayName()).zza("HasDebugAccess", (Object)player.zzmD()).zza("IconImageUri", (Object)player.getIconImageUri()).zza("IconImageUrl", (Object)player.getIconImageUrl()).zza("HiResImageUri", (Object)player.getHiResImageUri()).zza("HiResImageUrl", (Object)player.getHiResImageUrl()).zza("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zza("Title", (Object)player.getTitle()).zza("LevelInfo", (Object)player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zziY()) {
            PlayerEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzacH);
            dest.writeString(this.zzSJ);
            dest.writeString(this.zzacc == null ? null : this.zzacc.toString());
            dest.writeString(this.zzacd == null ? null : this.zzacd.toString());
            dest.writeLong(this.zzacI);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzcQ(Parcel parcel) {
            boolean bl = PlayerEntity.zzd(PlayerEntity.zziX());
            if (bl || PlayerEntity.zzbf((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzcQ(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            int n = -1;
            long l2 = -1L;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl2 = true;
            boolean bl3 = false;
            return new PlayerEntity(12, string, string2, uri, uri2, l, n, l2, string5, string6, string7, mostRecentGameInfoEntity, playerLevelInfo, bl2, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzcQ(x0);
        }
    }
}

