/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final SnapshotMetadataEntityCreator CREATOR = new SnapshotMetadataEntityCreator();
    private final int CK;
    private final GameEntity acs;
    private final PlayerEntity afg;
    private final String YB;
    private final Uri afd;
    private final String afh;
    private final String OH;
    private final String UO;
    private final long afi;
    private final long afj;
    private final float afk;
    private final String afl;
    private final boolean afm;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.CK = 4;
        this.acs = new GameEntity(snapshotMetadata.getGame());
        this.afg = new PlayerEntity(snapshotMetadata.getOwner());
        this.YB = snapshotMetadata.getSnapshotId();
        this.afd = snapshotMetadata.getCoverImageUri();
        this.afh = snapshotMetadata.getCoverImageUrl();
        this.afk = snapshotMetadata.getCoverImageAspectRatio();
        this.OH = snapshotMetadata.getTitle();
        this.UO = snapshotMetadata.getDescription();
        this.afi = snapshotMetadata.getLastModifiedTimestamp();
        this.afj = snapshotMetadata.getPlayedTime();
        this.afl = snapshotMetadata.getUniqueName();
        this.afm = snapshotMetadata.hasChangePending();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending) {
        this.CK = versionCode;
        this.acs = game;
        this.afg = owner;
        this.YB = snapshotId;
        this.afd = coverImageUri;
        this.afh = coverImageUrl;
        this.afk = coverImageAspectRatio;
        this.OH = title;
        this.UO = description;
        this.afi = lastModifiedTimestamp;
        this.afj = playedTime;
        this.afl = uniqueName;
        this.afm = changePending;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public Game getGame() {
        return this.acs;
    }

    @Override
    public Player getOwner() {
        return this.afg;
    }

    @Override
    public String getSnapshotId() {
        return this.YB;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.afd;
    }

    @Override
    public String getCoverImageUrl() {
        return this.afh;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.afk;
    }

    @Override
    public String getUniqueName() {
        return this.afl;
    }

    @Override
    public String getTitle() {
        return this.OH;
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b((String)this.UO, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.afi;
    }

    @Override
    public long getPlayedTime() {
        return this.afj;
    }

    @Override
    public boolean hasChangePending() {
        return this.afm;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.a(this);
    }

    static int a(SnapshotMetadata snapshotMetadata) {
        return jv.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending()});
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.a(this, obj);
    }

    static boolean a(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return jv.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && jv.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && jv.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && jv.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && jv.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && jv.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && jv.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && jv.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && jv.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && jv.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && jv.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending());
    }

    public String toString() {
        return SnapshotMetadataEntity.b(this);
    }

    static String b(SnapshotMetadata snapshotMetadata) {
        return jv.h((Object)snapshotMetadata).a("Game", (Object)snapshotMetadata.getGame()).a("Owner", (Object)snapshotMetadata.getOwner()).a("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).a("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).a("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).a("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).a("Description", (Object)snapshotMetadata.getDescription()).a("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).a("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).a("UniqueName", (Object)snapshotMetadata.getUniqueName()).a("ChangePending", (Object)snapshotMetadata.hasChangePending()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.a(this, out, flags);
    }
}

