/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntityCreator;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.lh;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public final class SnapshotContentsEntity
implements SafeParcelable,
SnapshotContents {
    private static final Object aeY = new Object();
    public static final SnapshotContentsEntityCreator CREATOR = new SnapshotContentsEntityCreator();
    private final int CK;
    private Contents PW;

    public SnapshotContentsEntity(Contents contents) {
        this(1, contents);
    }

    SnapshotContentsEntity(int versionCode, Contents contents) {
        this.CK = versionCode;
        this.PW = contents;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        jx.a((!this.isClosed() ? 1 : 0) != 0, (Object)"Cannot mutate closed contents!");
        return this.PW.getParcelFileDescriptor();
    }

    @Override
    public Contents ir() {
        return this.PW;
    }

    @Override
    public void close() {
        this.PW = null;
    }

    @Override
    public boolean isClosed() {
        return this.PW == null;
    }

    @Override
    public byte[] readFully() throws IOException {
        jx.a((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened Snapshot");
        Object object = aeY;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.PW.getParcelFileDescriptor();
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                fileInputStream.getChannel().position(0L);
                byte[] byArray = lh.a((InputStream)bufferedInputStream, (boolean)false);
                fileInputStream.getChannel().position(0L);
                return byArray;
            }
            catch (IOException iOException) {
                GamesLog.b("SnapshotContentsEntity", "Failed to read snapshot data", iOException);
                throw iOException;
            }
        }
    }

    @Override
    public boolean writeBytes(byte[] content) {
        return this.a(0, content, 0, content.length, true);
    }

    @Override
    public boolean modifyBytes(int dstOffset, byte[] content, int srcOffset, int count) {
        return this.a(dstOffset, content, srcOffset, content.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(int n, byte[] byArray, int n2, int n3, boolean bl) {
        jx.a((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened SnapshotContents");
        Object object = aeY;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.PW.getParcelFileDescriptor();
            FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.position(n);
                ((OutputStream)bufferedOutputStream).write(byArray, n2, n3);
                if (bl) {
                    fileChannel.truncate(byArray.length);
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            catch (IOException iOException) {
                GamesLog.a("SnapshotContentsEntity", "Failed to write snapshot data", iOException);
                return false;
            }
            return true;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotContentsEntityCreator.a(this, out, flags);
    }
}

