/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntity;
import java.util.ArrayList;
import java.util.List;

public final class GameRequestRef
extends d
implements GameRequest {
    private final int Ya;

    public GameRequestRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.Ya = numChildren;
    }

    @Override
    public String getRequestId() {
        return this.getString("external_request_id");
    }

    @Override
    public Game getGame() {
        return new GameRef(this.JG, this.KZ);
    }

    @Override
    public Player getSender() {
        return new PlayerRef(this.JG, this.gW(), "sender_");
    }

    @Override
    public List<Player> getRecipients() {
        ArrayList<Player> arrayList = new ArrayList<Player>(this.Ya);
        for (int i = 0; i < this.Ya; ++i) {
            arrayList.add(new PlayerRef(this.JG, this.KZ + i, "recipient_"));
        }
        return arrayList;
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.getByteArray("data");
    }

    @Override
    public int getType() {
        return this.getInteger("type");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public long getExpirationTimestamp() {
        return this.getLong("expiration_timestamp");
    }

    @Override
    public int getRecipientStatus(String playerId) {
        for (int i = this.KZ; i < this.KZ + this.Ya; ++i) {
            int n = this.JG.au(i);
            String string = this.JG.c("recipient_external_player_id", i, n);
            if (!string.equals(playerId)) continue;
            return this.JG.b("recipient_status", i, n);
        }
        return -1;
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    public GameRequest freeze() {
        return new GameRequestEntity(this);
    }

    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntity gameRequestEntity = (GameRequestEntity)this.freeze();
        gameRequestEntity.writeToParcel(dest, flags);
    }
}

