/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int CK;
    private final GameEntity acs;
    private final PlayerEntity aeU;
    private final byte[] aeA;
    private final String Zt;
    private final ArrayList<PlayerEntity> aeV;
    private final int Gt;
    private final long adS;
    private final long aeW;
    private final Bundle aeX;
    private final int FP;

    public GameRequestEntity(GameRequest request) {
        this.CK = 2;
        this.acs = new GameEntity(request.getGame());
        this.aeU = new PlayerEntity(request.getSender());
        this.Zt = request.getRequestId();
        this.Gt = request.getType();
        this.adS = request.getCreationTimestamp();
        this.aeW = request.getExpirationTimestamp();
        this.FP = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.aeA = null;
        } else {
            this.aeA = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.aeA, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n = list.size();
        this.aeV = new ArrayList(n);
        this.aeX = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.aeV.add((PlayerEntity)player);
            this.aeX.putInt(string, request.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.CK = versionCode;
        this.acs = game;
        this.aeU = sender;
        this.aeA = data;
        this.Zt = requestId;
        this.aeV = recipients;
        this.Gt = type;
        this.adS = creationTimestamp;
        this.aeW = expirationTimestamp;
        this.aeX = recipientStatuses;
        this.FP = status;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getRequestId() {
        return this.Zt;
    }

    @Override
    public Game getGame() {
        return this.acs;
    }

    @Override
    public Player getSender() {
        return this.aeU;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.aeV);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.aeA;
    }

    @Override
    public int getType() {
        return this.Gt;
    }

    @Override
    public long getCreationTimestamp() {
        return this.adS;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.aeW;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.aeX.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.FP;
    }

    public Bundle mS() {
        return this.aeX;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    static int a(GameRequest gameRequest) {
        return jv.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.b(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    static boolean a(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return jv.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && jv.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && jv.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && jv.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.b(gameRequest2), GameRequestEntity.b(gameRequest)) && jv.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && jv.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && jv.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] b(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    static String c(GameRequest gameRequest) {
        return jv.h((Object)gameRequest).a("Game", (Object)gameRequest.getGame()).a("Sender", (Object)gameRequest.getSender()).a("Recipients", gameRequest.getRecipients()).a("Data", (Object)gameRequest.getData()).a("RequestId", (Object)gameRequest.getRequestId()).a("Type", (Object)gameRequest.getType()).a("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).a("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.a(this, dest, flags);
    }
}

