/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final QuestEntityCreator CREATOR = new QuestEntityCreator();
    private final int CK;
    private final GameEntity acs;
    private final String aeK;
    private final long aeL;
    private final Uri aeM;
    private final String aeN;
    private final String UO;
    private final long aeO;
    private final long XH;
    private final Uri aeP;
    private final String aeQ;
    private final String mName;
    private final long aeR;
    private final long aeS;
    private final int mState;
    private final int Gt;
    private final ArrayList<MilestoneEntity> aeT;

    public QuestEntity(Quest quest) {
        this.CK = 2;
        this.acs = new GameEntity(quest.getGame());
        this.aeK = quest.getQuestId();
        this.aeL = quest.getAcceptedTimestamp();
        this.UO = quest.getDescription();
        this.aeM = quest.getBannerImageUri();
        this.aeN = quest.getBannerImageUrl();
        this.aeO = quest.getEndTimestamp();
        this.aeP = quest.getIconImageUri();
        this.aeQ = quest.getIconImageUrl();
        this.XH = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.aeR = quest.mR();
        this.aeS = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.Gt = quest.getType();
        List<Milestone> list = quest.mQ();
        int n = list.size();
        this.aeT = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.aeT.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.CK = versionCode;
        this.acs = game;
        this.aeK = questId;
        this.aeL = acceptedTimestamp;
        this.aeM = bannerImageUri;
        this.aeN = bannerImageUrl;
        this.UO = description;
        this.aeO = endTimestamp;
        this.XH = lastUpdatedTimestamp;
        this.aeP = iconImageUri;
        this.aeQ = iconImageUrl;
        this.mName = name;
        this.aeR = notifyTimestamp;
        this.aeS = startTimestamp;
        this.mState = state;
        this.Gt = type;
        this.aeT = milestones;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getQuestId() {
        return this.aeK;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        le.b((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b((String)this.UO, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.aeP;
    }

    @Override
    public String getIconImageUrl() {
        return this.aeQ;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.aeM;
    }

    @Override
    public String getBannerImageUrl() {
        return this.aeN;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.mQ().get(0);
    }

    @Override
    public List<Milestone> mQ() {
        return new ArrayList<Milestone>(this.aeT);
    }

    @Override
    public Game getGame() {
        return this.acs;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.Gt;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.aeL;
    }

    @Override
    public long getEndTimestamp() {
        return this.aeO;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.XH;
    }

    @Override
    public long mR() {
        return this.aeR;
    }

    @Override
    public long getStartTimestamp() {
        return this.aeS;
    }

    @Override
    public boolean isEndingSoon() {
        return this.aeR <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.a(this);
    }

    static int a(Quest quest) {
        return jv.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.mQ(), quest.getName(), quest.mR(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object obj) {
        return QuestEntity.a(this, obj);
    }

    static boolean a(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return jv.equal((Object)quest2.getGame(), (Object)quest.getGame()) && jv.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && jv.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && jv.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && jv.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && jv.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && jv.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && jv.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && jv.equal(quest2.mQ(), quest.mQ()) && jv.equal((Object)quest2.getName(), (Object)quest.getName()) && jv.equal((Object)quest2.mR(), (Object)quest.mR()) && jv.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && jv.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.b(this);
    }

    static String b(Quest quest) {
        return jv.h((Object)quest).a("Game", (Object)quest.getGame()).a("QuestId", (Object)quest.getQuestId()).a("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).a("BannerImageUri", (Object)quest.getBannerImageUri()).a("BannerImageUrl", (Object)quest.getBannerImageUrl()).a("Description", (Object)quest.getDescription()).a("EndTimestamp", (Object)quest.getEndTimestamp()).a("IconImageUri", (Object)quest.getIconImageUri()).a("IconImageUrl", (Object)quest.getIconImageUrl()).a("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).a("Milestones", quest.mQ()).a("Name", (Object)quest.getName()).a("NotifyTimestamp", (Object)quest.mR()).a("StartTimestamp", (Object)quest.getStartTimestamp()).a("State", (Object)quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.a(this, out, flags);
    }
}

