/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int CK;
    private final GameEntity acs;
    private final String Zb;
    private final String aep;
    private final long adS;
    private final String aex;
    private final long XH;
    private final String aey;
    private final int aez;
    private final int adW;
    private final int Ef;
    private final byte[] aeA;
    private final ArrayList<ParticipantEntity> adV;
    private final String aeB;
    private final byte[] aeC;
    private final int aeD;
    private final Bundle aem;
    private final int aeE;
    private final boolean aeF;
    private final String UO;
    private final String aeG;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.CK = 2;
        this.acs = new GameEntity(match.getGame());
        this.Zb = match.getMatchId();
        this.aep = match.getCreatorId();
        this.adS = match.getCreationTimestamp();
        this.aex = match.getLastUpdaterId();
        this.XH = match.getLastUpdatedTimestamp();
        this.aey = match.getPendingParticipantId();
        this.aez = match.getStatus();
        this.aeE = match.getTurnStatus();
        this.adW = match.getVariant();
        this.Ef = match.getVersion();
        this.aeB = match.getRematchId();
        this.aeD = match.getMatchNumber();
        this.aem = match.getAutoMatchCriteria();
        this.aeF = match.isLocallyModified();
        this.UO = match.getDescription();
        this.aeG = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.aeA = null;
        } else {
            this.aeA = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.aeA, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.aeC = null;
        } else {
            this.aeC = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.aeC, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n = arrayList.size();
        this.adV = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.adV.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.CK = versionCode;
        this.acs = game;
        this.Zb = matchId;
        this.aep = creatorId;
        this.adS = creationTimestamp;
        this.aex = lastUpdaterId;
        this.XH = lastUpdatedTimestamp;
        this.aey = pendingParticipantId;
        this.aez = matchStatus;
        this.aeE = turnStatus;
        this.adW = variant;
        this.Ef = version;
        this.aeA = data;
        this.adV = participants;
        this.aeB = rematchId;
        this.aeC = previousData;
        this.aeD = matchNumber;
        this.aem = autoMatchCriteria;
        this.aeF = isLocallyModified;
        this.UO = description;
        this.aeG = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public Game getGame() {
        return this.acs;
    }

    @Override
    public String getMatchId() {
        return this.Zb;
    }

    @Override
    public String getCreatorId() {
        return this.aep;
    }

    @Override
    public long getCreationTimestamp() {
        return this.adS;
    }

    @Override
    public String getLastUpdaterId() {
        return this.aex;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.XH;
    }

    @Override
    public String getPendingParticipantId() {
        return this.aey;
    }

    @Override
    public int getStatus() {
        return this.aez;
    }

    @Override
    public int getTurnStatus() {
        return this.aeE;
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.aeG;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b((String)this.UO, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.adW;
    }

    @Override
    public byte[] getData() {
        return this.aeA;
    }

    @Override
    public int getVersion() {
        return this.Ef;
    }

    @Override
    public String getRematchId() {
        return this.aeB;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.aeC;
    }

    @Override
    public int getMatchNumber() {
        return this.aeD;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.aem;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.aem == null) {
            return 0;
        }
        return this.aem.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.aez == 2 && this.aeB == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.aeF;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.adV);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return jv.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return jv.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && jv.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && jv.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && jv.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && jv.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && jv.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && jv.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && jv.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && jv.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && jv.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && jv.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && jv.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && jv.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && jv.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && jv.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && jv.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && jv.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && jv.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return jv.h((Object)turnBasedMatch).a("Game", (Object)turnBasedMatch.getGame()).a("MatchId", (Object)turnBasedMatch.getMatchId()).a("CreatorId", (Object)turnBasedMatch.getCreatorId()).a("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).a("MatchStatus", (Object)turnBasedMatch.getStatus()).a("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).a("Description", (Object)turnBasedMatch.getDescription()).a("Variant", (Object)turnBasedMatch.getVariant()).a("Data", (Object)turnBasedMatch.getData()).a("Version", (Object)turnBasedMatch.getVersion()).a("Participants", (Object)turnBasedMatch.getParticipants()).a("RematchId", (Object)turnBasedMatch.getRematchId()).a("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).a("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).a("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }
}

