/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer aes;
    private final TurnBasedMatchBuffer aet;
    private final TurnBasedMatchBuffer aeu;
    private final TurnBasedMatchBuffer aev;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.a(matchData, 0);
        this.aes = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.a(matchData, 1);
        this.aet = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.a(matchData, 2);
        this.aeu = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.a(matchData, 3);
        this.aev = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder a(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.dZ(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.aes;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.aet;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.aeu;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.aev;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.aes != null) {
            this.aes.release();
        }
        if (this.aet != null) {
            this.aet.release();
        }
        if (this.aeu != null) {
            this.aeu.release();
        }
        if (this.aev != null) {
            this.aev.release();
        }
    }

    public boolean hasData() {
        if (this.aes != null && this.aes.getCount() > 0) {
            return true;
        }
        if (this.aet != null && this.aet.getCount() > 0) {
            return true;
        }
        if (this.aeu != null && this.aeu.getCount() > 0) {
            return true;
        }
        return this.aev != null && this.aev.getCount() > 0;
    }
}

