/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int CK;
    private final String YI;
    private final String aep;
    private final long adS;
    private final int aeq;
    private final String UO;
    private final int adW;
    private final Bundle aem;
    private final ArrayList<ParticipantEntity> adV;
    private final int aer;

    public RoomEntity(Room room) {
        this.CK = 2;
        this.YI = room.getRoomId();
        this.aep = room.getCreatorId();
        this.adS = room.getCreationTimestamp();
        this.aeq = room.getStatus();
        this.UO = room.getDescription();
        this.adW = room.getVariant();
        this.aem = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.adV = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.adV.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.aer = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.CK = versionCode;
        this.YI = roomId;
        this.aep = creatorId;
        this.adS = creationTimestamp;
        this.aeq = roomStatus;
        this.UO = description;
        this.adW = variant;
        this.aem = autoMatchCriteria;
        this.adV = participants;
        this.aer = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getRoomId() {
        return this.YI;
    }

    @Override
    public String getCreatorId() {
        return this.aep;
    }

    @Override
    public long getCreationTimestamp() {
        return this.adS;
    }

    @Override
    public int getStatus() {
        return this.aeq;
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b((String)this.UO, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.adW;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.aem;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.adV);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.aer;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.a((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.c(this, participantId);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    static int a(Room room) {
        return jv.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object obj) {
        return RoomEntity.a((Room)this, obj);
    }

    static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return jv.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && jv.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && jv.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && jv.equal((Object)room2.getStatus(), (Object)room.getStatus()) && jv.equal((Object)room2.getDescription(), (Object)room.getDescription()) && jv.equal((Object)room2.getVariant(), (Object)room.getVariant()) && jv.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && jv.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && jv.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    static String b(Room room) {
        return jv.h((Object)room).a("RoomId", (Object)room.getRoomId()).a("CreatorId", (Object)room.getCreatorId()).a("CreationTimestamp", (Object)room.getCreationTimestamp()).a("RoomStatus", (Object)room.getStatus()).a("Description", (Object)room.getDescription()).a("Variant", (Object)room.getVariant()).a("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).a("Participants", (Object)room.getParticipants()).a("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            RoomEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.YI);
            dest.writeString(this.aep);
            dest.writeLong(this.adS);
            dest.writeInt(this.aeq);
            dest.writeString(this.UO);
            dest.writeInt(this.adW);
            dest.writeBundle(this.aem);
            int n = this.adV.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.adV.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static int a(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> c(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant c(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity cC(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.c(RoomEntity.ht());
            if (bl || RoomEntity.aW((String)RoomEntity.class.getCanonicalName())) {
                return super.cC(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, n);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cC(x0);
        }
    }
}

