/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int CK;
    private final GameEntity acs;
    private final String YG;
    private final long adS;
    private final int adT;
    private final ParticipantEntity adU;
    private final ArrayList<ParticipantEntity> adV;
    private final int adW;
    private final int adX;

    InvitationEntity(Invitation invitation) {
        this.CK = 2;
        this.acs = new GameEntity(invitation.getGame());
        this.YG = invitation.getInvitationId();
        this.adS = invitation.getCreationTimestamp();
        this.adT = invitation.getInvitationType();
        this.adW = invitation.getVariant();
        this.adX = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.adV = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.adV.add((ParticipantEntity)participant2.freeze());
        }
        jx.b(participant, (Object)"Must have a valid inviter!");
        this.adU = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.CK = versionCode;
        this.acs = game;
        this.YG = invitationId;
        this.adS = creationTimestamp;
        this.adT = invitationType;
        this.adU = inviter;
        this.adV = participants;
        this.adW = variant;
        this.adX = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public Game getGame() {
        return this.acs;
    }

    @Override
    public String getInvitationId() {
        return this.YG;
    }

    @Override
    public Participant getInviter() {
        return this.adU;
    }

    @Override
    public long getCreationTimestamp() {
        return this.adS;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.adV);
    }

    @Override
    public int getInvitationType() {
        return this.adT;
    }

    @Override
    public int getVariant() {
        return this.adW;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.adX;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return jv.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return jv.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && jv.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && jv.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && jv.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && jv.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && jv.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && jv.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && jv.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return jv.h((Object)invitation).a("Game", (Object)invitation.getGame()).a("InvitationId", (Object)invitation.getInvitationId()).a("CreationTimestamp", (Object)invitation.getCreationTimestamp()).a("InvitationType", (Object)invitation.getInvitationType()).a("Inviter", (Object)invitation.getInviter()).a("Participants", (Object)invitation.getParticipants()).a("Variant", (Object)invitation.getVariant()).a("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            InvitationEntityCreator.a(this, dest, flags);
        } else {
            this.acs.writeToParcel(dest, flags);
            dest.writeString(this.YG);
            dest.writeLong(this.adS);
            dest.writeInt(this.adT);
            this.adU.writeToParcel(dest, flags);
            int n = this.adV.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.adV.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity cz(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.c(InvitationEntity.ht());
            if (bl || InvitationEntity.aW((String)InvitationEntity.class.getCanonicalName())) {
                return super.cz(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            int n4 = 0;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, n, n4);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cz(x0);
        }
    }
}

