/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;
import com.google.android.gms.internal.le;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long ads;
    private final String adt;
    private final String adu;
    private final long adv;
    private final long adw;
    private final String adx;
    private final Uri ady;
    private final Uri adz;
    private final PlayerEntity adA;
    private final String adB;
    private final String adC;
    private final String adD;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.ads = score.getRank();
        this.adt = (String)jx.i((Object)score.getDisplayRank());
        this.adu = (String)jx.i((Object)score.getDisplayScore());
        this.adv = score.getRawScore();
        this.adw = score.getTimestampMillis();
        this.adx = score.getScoreHolderDisplayName();
        this.ady = score.getScoreHolderIconImageUri();
        this.adz = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.adA = player == null ? null : (PlayerEntity)player.freeze();
        this.adB = score.getScoreTag();
        this.adC = score.getScoreHolderIconImageUrl();
        this.adD = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.ads;
    }

    @Override
    public String getDisplayRank() {
        return this.adt;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        le.b((String)this.adt, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.adu;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        le.b((String)this.adu, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getRawScore() {
        return this.adv;
    }

    @Override
    public long getTimestampMillis() {
        return this.adw;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.adA == null) {
            return this.adx;
        }
        return this.adA.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.adA == null) {
            le.b((String)this.adx, (CharArrayBuffer)dataOut);
            return;
        }
        this.adA.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.adA == null) {
            return this.ady;
        }
        return this.adA.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.adA == null) {
            return this.adC;
        }
        return this.adA.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.adA == null) {
            return this.adz;
        }
        return this.adA.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.adA == null) {
            return this.adD;
        }
        return this.adA.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.adA;
    }

    @Override
    public String getScoreTag() {
        return this.adB;
    }

    public LeaderboardScore mJ() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return jv.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return jv.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && jv.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && jv.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && jv.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && jv.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && jv.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && jv.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && jv.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && jv.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && jv.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return jv.h((Object)leaderboardScore).a("Rank", (Object)leaderboardScore.getRank()).a("DisplayRank", (Object)leaderboardScore.getDisplayRank()).a("Score", (Object)leaderboardScore.getRawScore()).a("DisplayScore", (Object)leaderboardScore.getDisplayScore()).a("Timestamp", (Object)leaderboardScore.getTimestampMillis()).a("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).a("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).a("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).a("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).a("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).a("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.mJ();
    }
}

