/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String adn;
    private final String OS;
    private final Uri WD;
    private final int ado;
    private final ArrayList<LeaderboardVariantEntity> adp;
    private final Game adq;
    private final String WO;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.adn = leaderboard.getLeaderboardId();
        this.OS = leaderboard.getDisplayName();
        this.WD = leaderboard.getIconImageUri();
        this.WO = leaderboard.getIconImageUrl();
        this.ado = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.adq = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.adp = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.adp.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.adn;
    }

    @Override
    public String getDisplayName() {
        return this.OS;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        le.b((String)this.OS, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.WD;
    }

    @Override
    public String getIconImageUrl() {
        return this.WO;
    }

    @Override
    public int getScoreOrder() {
        return this.ado;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.adp);
    }

    @Override
    public Game getGame() {
        return this.adq;
    }

    public Leaderboard mG() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.a(this);
    }

    static int a(Leaderboard leaderboard) {
        return jv.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.a(this, obj);
    }

    static boolean a(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return jv.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && jv.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && jv.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && jv.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && jv.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.b(this);
    }

    static String b(Leaderboard leaderboard) {
        return jv.h((Object)leaderboard).a("LeaderboardId", (Object)leaderboard.getLeaderboardId()).a("DisplayName", (Object)leaderboard.getDisplayName()).a("IconImageUri", (Object)leaderboard.getIconImageUri()).a("IconImageUrl", (Object)leaderboard.getIconImageUrl()).a("ScoreOrder", (Object)leaderboard.getScoreOrder()).a("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.mG();
    }
}

