/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.os.Parcel;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.ExtendedGame;
import com.google.android.gms.games.internal.game.ExtendedGameEntityCreator;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;

public final class ExtendedGameEntity
extends GamesDowngradeableSafeParcel
implements ExtendedGame {
    public static final ExtendedGameEntityCreator CREATOR = new ExtendedGameEntityCreatorCompat();
    private final int CK;
    private final GameEntity acs;
    private final int act;
    private final boolean acu;
    private final int acv;
    private final long acw;
    private final long acx;
    private final String acy;
    private final long acz;
    private final String acA;
    private final ArrayList<GameBadgeEntity> acB;
    private final SnapshotMetadataEntity acC;

    public ExtendedGameEntity(ExtendedGame extendedGame) {
        this.CK = 2;
        Game game = extendedGame.getGame();
        this.acs = game == null ? null : new GameEntity(game);
        this.act = extendedGame.lZ();
        this.acu = extendedGame.ma();
        this.acv = extendedGame.mb();
        this.acw = extendedGame.mc();
        this.acx = extendedGame.md();
        this.acy = extendedGame.me();
        this.acz = extendedGame.mf();
        this.acA = extendedGame.mg();
        SnapshotMetadata snapshotMetadata = extendedGame.mh();
        this.acC = snapshotMetadata == null ? null : new SnapshotMetadataEntity(snapshotMetadata);
        ArrayList<GameBadge> arrayList = extendedGame.lY();
        int n = arrayList.size();
        this.acB = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.acB.add((GameBadgeEntity)arrayList.get(i).freeze());
        }
    }

    ExtendedGameEntity(int versionCode, GameEntity game, int availability, boolean owned, int achievementUnlockedCount, long lastPlayedServerTimestamp, long priceMicros, String formattedPrice, long fullPriceMicros, String formattedFullPrice, ArrayList<GameBadgeEntity> badges, SnapshotMetadataEntity snapshot) {
        this.CK = versionCode;
        this.acs = game;
        this.act = availability;
        this.acu = owned;
        this.acv = achievementUnlockedCount;
        this.acw = lastPlayedServerTimestamp;
        this.acx = priceMicros;
        this.acy = formattedPrice;
        this.acz = fullPriceMicros;
        this.acA = formattedFullPrice;
        this.acB = badges;
        this.acC = snapshot;
    }

    public int getVersionCode() {
        return this.CK;
    }

    public GameEntity mi() {
        return this.acs;
    }

    @Override
    public ArrayList<GameBadge> lY() {
        return new ArrayList<GameBadge>(this.acB);
    }

    @Override
    public int lZ() {
        return this.act;
    }

    @Override
    public boolean ma() {
        return this.acu;
    }

    @Override
    public int mb() {
        return this.acv;
    }

    @Override
    public long mc() {
        return this.acw;
    }

    @Override
    public long md() {
        return this.acx;
    }

    @Override
    public String me() {
        return this.acy;
    }

    @Override
    public long mf() {
        return this.acz;
    }

    @Override
    public String mg() {
        return this.acA;
    }

    @Override
    public SnapshotMetadata mh() {
        return this.acC;
    }

    public ExtendedGame mj() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ExtendedGameEntity.a(this);
    }

    static int a(ExtendedGame extendedGame) {
        return jv.hashCode((Object[])new Object[]{extendedGame.getGame(), extendedGame.lZ(), extendedGame.ma(), extendedGame.mb(), extendedGame.mc(), extendedGame.md(), extendedGame.me(), extendedGame.mf(), extendedGame.mg()});
    }

    public boolean equals(Object obj) {
        return ExtendedGameEntity.a(this, obj);
    }

    static boolean a(ExtendedGame extendedGame, Object object) {
        if (!(object instanceof ExtendedGame)) {
            return false;
        }
        if (extendedGame == object) {
            return true;
        }
        ExtendedGame extendedGame2 = (ExtendedGame)object;
        return jv.equal((Object)extendedGame2.getGame(), (Object)extendedGame.getGame()) && jv.equal((Object)extendedGame2.lZ(), (Object)extendedGame.lZ()) && jv.equal((Object)extendedGame2.ma(), (Object)extendedGame.ma()) && jv.equal((Object)extendedGame2.mb(), (Object)extendedGame.mb()) && jv.equal((Object)extendedGame2.mc(), (Object)extendedGame.mc()) && jv.equal((Object)extendedGame2.md(), (Object)extendedGame.md()) && jv.equal((Object)extendedGame2.me(), (Object)extendedGame.me()) && jv.equal((Object)extendedGame2.mf(), (Object)extendedGame.mf()) && jv.equal((Object)extendedGame2.mg(), (Object)extendedGame.mg());
    }

    public String toString() {
        return ExtendedGameEntity.b(this);
    }

    static String b(ExtendedGame extendedGame) {
        return jv.h((Object)extendedGame).a("Game", (Object)extendedGame.getGame()).a("Availability", (Object)extendedGame.lZ()).a("Owned", (Object)extendedGame.ma()).a("AchievementUnlockedCount", (Object)extendedGame.mb()).a("LastPlayedServerTimestamp", (Object)extendedGame.mc()).a("PriceMicros", (Object)extendedGame.md()).a("FormattedPrice", (Object)extendedGame.me()).a("FullPriceMicros", (Object)extendedGame.mf()).a("FormattedFullPrice", (Object)extendedGame.mg()).a("Snapshot", (Object)extendedGame.mh()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            ExtendedGameEntityCreator.a(this, dest, flags);
        } else {
            this.acs.writeToParcel(dest, flags);
            dest.writeInt(this.act);
            dest.writeInt(this.acu ? 1 : 0);
            dest.writeInt(this.acv);
            dest.writeLong(this.acw);
            dest.writeLong(this.acx);
            dest.writeString(this.acy);
            dest.writeLong(this.acz);
            dest.writeString(this.acA);
            int n = this.acB.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.acB.get(i).writeToParcel(dest, flags);
            }
        }
    }

    @Override
    public /* synthetic */ Game getGame() {
        return this.mi();
    }

    public /* synthetic */ Object freeze() {
        return this.mj();
    }

    static final class ExtendedGameEntityCreatorCompat
    extends ExtendedGameEntityCreator {
        ExtendedGameEntityCreatorCompat() {
        }

        @Override
        public ExtendedGameEntity cu(Parcel parcel) {
            boolean bl = ExtendedGameEntity.c(ExtendedGameEntity.ht());
            if (bl || ExtendedGameEntity.aW((String)ExtendedGameEntity.class.getCanonicalName())) {
                return super.cu(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            int n = parcel.readInt();
            boolean bl2 = parcel.readInt() == 1;
            int n2 = parcel.readInt();
            long l = parcel.readLong();
            long l2 = parcel.readLong();
            String string = parcel.readString();
            long l3 = parcel.readLong();
            String string2 = parcel.readString();
            int n3 = parcel.readInt();
            ArrayList<GameBadgeEntity> arrayList = new ArrayList<GameBadgeEntity>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(GameBadgeEntity.CREATOR.cv(parcel));
            }
            SnapshotMetadataEntity snapshotMetadataEntity = null;
            return new ExtendedGameEntity(2, gameEntity, n, bl2, n2, l, l2, string, l3, string2, arrayList, snapshotMetadataEntity);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cu(x0);
        }
    }
}

