/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.d;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import java.util.List;

public final class TurnBasedMultiplayerImpl
implements TurnBasedMultiplayer {
    @Override
    public Intent getInboxIntent(GoogleApiClient apiClient) {
        return Games.d(apiClient).ln();
    }

    @Override
    public void registerMatchUpdateListener(GoogleApiClient apiClient, OnTurnBasedMatchUpdateReceivedListener listener) {
        d d2 = apiClient.d((Object)listener);
        Games.d(apiClient).b((d<OnTurnBasedMatchUpdateReceivedListener>)d2);
    }

    @Override
    public void unregisterMatchUpdateListener(GoogleApiClient apiClient) {
        Games.d(apiClient).lq();
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers) {
        return Games.d(apiClient).a(minPlayers, maxPlayers, true);
    }

    @Override
    public Intent getSelectOpponentsIntent(GoogleApiClient apiClient, int minPlayers, int maxPlayers, boolean allowAutomatch) {
        return Games.d(apiClient).a(minPlayers, maxPlayers, allowAutomatch);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> createMatch(GoogleApiClient apiClient, final TurnBasedMatchConfig config) {
        return apiClient.b((BaseImplementation.a)new InitiateMatchImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult>)this, config);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> rematch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.b((BaseImplementation.a)new InitiateMatchImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.c((BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult>)this, matchId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.InitiateMatchResult> acceptInvitation(GoogleApiClient apiClient, final String invitationId) {
        return apiClient.b((BaseImplementation.a)new InitiateMatchImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.d((BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult>)this, invitationId);
            }
        });
    }

    @Override
    public void declineInvitation(GoogleApiClient apiClient, String invitationId) {
        Games.d(apiClient).q(invitationId, 1);
    }

    @Override
    public void dismissInvitation(GoogleApiClient apiClient, String invitationId) {
        Games.d(apiClient).p(invitationId, 1);
    }

    @Override
    public int getMaxMatchDataSize(GoogleApiClient apiClient) {
        return Games.d(apiClient).lx();
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, String matchId, byte[] matchData, String pendingParticipantId) {
        return this.takeTurn(apiClient, matchId, matchData, pendingParticipantId, (ParticipantResult[])null);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, final String matchId, final byte[] matchData, final String pendingParticipantId, final ParticipantResult ... results) {
        return apiClient.b((BaseImplementation.a)new UpdateMatchImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult>)this, matchId, matchData, pendingParticipantId, results);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> takeTurn(GoogleApiClient apiClient, String matchId, byte[] matchData, String pendingParticipantId, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        return this.takeTurn(apiClient, matchId, matchData, pendingParticipantId, participantResultArray);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, String matchId) {
        return this.finishMatch(apiClient, matchId, null, (ParticipantResult[])null);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, final String matchId, final byte[] matchData, final ParticipantResult ... results) {
        return apiClient.b((BaseImplementation.a)new UpdateMatchImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult>)this, matchId, matchData, results);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.UpdateMatchResult> finishMatch(GoogleApiClient apiClient, String matchId, byte[] matchData, List<ParticipantResult> results) {
        ParticipantResult[] participantResultArray = results == null ? null : results.toArray(new ParticipantResult[results.size()]);
        return this.finishMatch(apiClient, matchId, matchData, participantResultArray);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LeaveMatchResult> leaveMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.b((BaseImplementation.a)new LeaveMatchImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.e((BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult>)this, matchId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LeaveMatchResult> leaveMatchDuringTurn(GoogleApiClient apiClient, final String matchId, final String pendingParticipantId) {
        return apiClient.b((BaseImplementation.a)new LeaveMatchImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult>)this, matchId, pendingParticipantId);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.CancelMatchResult> cancelMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.b((BaseImplementation.a)new CancelMatchImpl(matchId, apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.f((BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult>)this, matchId);
            }
        });
    }

    @Override
    public void dismissMatch(GoogleApiClient apiClient, String matchId) {
        Games.d(apiClient).bA(matchId);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchesResult> loadMatchesByStatus(GoogleApiClient apiClient, int[] matchTurnStatuses) {
        return this.loadMatchesByStatus(apiClient, 0, matchTurnStatuses);
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchesResult> loadMatchesByStatus(GoogleApiClient apiClient, final int invitationSortOrder, final int[] matchTurnStatuses) {
        return apiClient.a((BaseImplementation.a)new LoadMatchesImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult>)this, invitationSortOrder, matchTurnStatuses);
            }
        });
    }

    @Override
    public PendingResult<TurnBasedMultiplayer.LoadMatchResult> loadMatch(GoogleApiClient apiClient, final String matchId) {
        return apiClient.a((BaseImplementation.a)new LoadMatchImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.g((BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult>)this, matchId);
            }
        });
    }

    private static abstract class LoadMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LoadMatchResult> {
        private LoadMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LoadMatchResult av(final Status status) {
            return new TurnBasedMultiplayer.LoadMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.av(status);
        }
    }

    private static abstract class LoadMatchesImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LoadMatchesResult> {
        private LoadMatchesImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LoadMatchesResult aw(final Status status) {
            return new TurnBasedMultiplayer.LoadMatchesResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public LoadMatchesResponse getMatches() {
                    return new LoadMatchesResponse(new Bundle());
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.aw(status);
        }
    }

    private static abstract class CancelMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.CancelMatchResult> {
        private final String CE;

        public CancelMatchImpl(String id, GoogleApiClient googleApiClient) {
            super(googleApiClient);
            this.CE = id;
        }

        public TurnBasedMultiplayer.CancelMatchResult as(final Status status) {
            return new TurnBasedMultiplayer.CancelMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public String getMatchId() {
                    return CancelMatchImpl.this.CE;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.as(status);
        }
    }

    private static abstract class LeaveMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.LeaveMatchResult> {
        private LeaveMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.LeaveMatchResult au(final Status status) {
            return new TurnBasedMultiplayer.LeaveMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.au(status);
        }
    }

    private static abstract class UpdateMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.UpdateMatchResult> {
        private UpdateMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.UpdateMatchResult ax(final Status status) {
            return new TurnBasedMultiplayer.UpdateMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.ax(status);
        }
    }

    private static abstract class InitiateMatchImpl
    extends Games.BaseGamesApiMethodImpl<TurnBasedMultiplayer.InitiateMatchResult> {
        private InitiateMatchImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public TurnBasedMultiplayer.InitiateMatchResult at(final Status status) {
            return new TurnBasedMultiplayer.InitiateMatchResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public TurnBasedMatch getMatch() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.at(status);
        }
    }
}

