/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.d;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;

public final class QuestsImpl
implements Quests {
    @Override
    public Intent getQuestsIntent(GoogleApiClient apiClient, int[] questSelectors) {
        return Games.d(apiClient).b(questSelectors);
    }

    @Override
    public Intent getQuestIntent(GoogleApiClient apiClient, String questId) {
        return Games.d(apiClient).bE(questId);
    }

    @Override
    public void registerQuestUpdateListener(GoogleApiClient apiClient, QuestUpdateListener listener) {
        d d2 = apiClient.d((Object)listener);
        Games.d(apiClient).c((d<QuestUpdateListener>)d2);
    }

    @Override
    public void unregisterQuestUpdateListener(GoogleApiClient apiClient) {
        Games.d(apiClient).lr();
    }

    @Override
    public PendingResult<Quests.AcceptQuestResult> accept(GoogleApiClient apiClient, final String questId) {
        return apiClient.b((BaseImplementation.a)new AcceptImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.h((BaseImplementation.b<Quests.AcceptQuestResult>)this, questId);
            }
        });
    }

    @Override
    public PendingResult<Quests.ClaimMilestoneResult> claim(GoogleApiClient apiClient, final String questId, final String milestoneId) {
        return apiClient.b((BaseImplementation.a)new ClaimImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b((BaseImplementation.b<Quests.ClaimMilestoneResult>)this, questId, milestoneId);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> load(GoogleApiClient apiClient, final int[] questSelectors, final int sortOrder, final boolean forceReload) {
        return apiClient.a((BaseImplementation.a)new LoadsImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<Quests.LoadQuestsResult>)this, questSelectors, sortOrder, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Quests.LoadQuestsResult> loadByIds(GoogleApiClient apiClient, final boolean forceReload, final String ... questIds) {
        return apiClient.a((BaseImplementation.a)new LoadsImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b((BaseImplementation.b<Quests.LoadQuestsResult>)this, forceReload, questIds);
            }
        });
    }

    @Override
    public void showStateChangedPopup(GoogleApiClient apiClient, String questId) {
        Games.d(apiClient).bF(questId);
    }

    private static abstract class LoadsImpl
    extends Games.BaseGamesApiMethodImpl<Quests.LoadQuestsResult> {
        private LoadsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.LoadQuestsResult aj(final Status status) {
            return new Quests.LoadQuestsResult(){

                public void release() {
                }

                public Status getStatus() {
                    return status;
                }

                @Override
                public QuestBuffer getQuests() {
                    int n = status.getStatusCode();
                    return new QuestBuffer(DataHolder.av((int)n));
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.aj(status);
        }
    }

    private static abstract class ClaimImpl
    extends Games.BaseGamesApiMethodImpl<Quests.ClaimMilestoneResult> {
        private ClaimImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.ClaimMilestoneResult ai(final Status status) {
            return new Quests.ClaimMilestoneResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Milestone getMilestone() {
                    return null;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.ai(status);
        }
    }

    private static abstract class AcceptImpl
    extends Games.BaseGamesApiMethodImpl<Quests.AcceptQuestResult> {
        private AcceptImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Quests.AcceptQuestResult ah(final Status status) {
            return new Quests.AcceptQuestResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public Quest getQuest() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.ah(status);
        }
    }
}

