/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;

public final class LeaderboardsImpl
implements Leaderboards {
    @Override
    public Intent getAllLeaderboardsIntent(GoogleApiClient apiClient) {
        return Games.d(apiClient).ll();
    }

    @Override
    public Intent getLeaderboardIntent(GoogleApiClient apiClient, String leaderboardId) {
        return this.getLeaderboardIntent(apiClient, leaderboardId, -1);
    }

    @Override
    public Intent getLeaderboardIntent(GoogleApiClient apiClient, String leaderboardId, int timeSpan) {
        return Games.d(apiClient).n(leaderboardId, timeSpan);
    }

    @Override
    public PendingResult<Leaderboards.LeaderboardMetadataResult> loadLeaderboardMetadata(GoogleApiClient apiClient, final boolean forceReload) {
        return apiClient.a((BaseImplementation.a)new LoadMetadataImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b((BaseImplementation.b<Leaderboards.LeaderboardMetadataResult>)this, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LeaderboardMetadataResult> loadLeaderboardMetadata(GoogleApiClient apiClient, final String leaderboardId, final boolean forceReload) {
        return apiClient.a((BaseImplementation.a)new LoadMetadataImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b((BaseImplementation.b<Leaderboards.LeaderboardMetadataResult>)this, leaderboardId, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LoadPlayerScoreResult> loadCurrentPlayerLeaderboardScore(GoogleApiClient apiClient, final String leaderboardId, final int span, final int leaderboardCollection) {
        return apiClient.a((BaseImplementation.a)new LoadPlayerScoreImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<Leaderboards.LoadPlayerScoreResult>)this, null, leaderboardId, span, leaderboardCollection);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadTopScores(GoogleApiClient apiClient, String leaderboardId, int span, int leaderboardCollection, int maxResults) {
        return this.loadTopScores(apiClient, leaderboardId, span, leaderboardCollection, maxResults, false);
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadTopScores(GoogleApiClient apiClient, final String leaderboardId, final int span, final int leaderboardCollection, final int maxResults, final boolean forceReload) {
        return apiClient.a((BaseImplementation.a)new LoadScoresImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<Leaderboards.LoadScoresResult>)this, leaderboardId, span, leaderboardCollection, maxResults, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadPlayerCenteredScores(GoogleApiClient apiClient, String leaderboardId, int span, int leaderboardCollection, int maxResults) {
        return this.loadPlayerCenteredScores(apiClient, leaderboardId, span, leaderboardCollection, maxResults, false);
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadPlayerCenteredScores(GoogleApiClient apiClient, final String leaderboardId, final int span, final int leaderboardCollection, final int maxResults, final boolean forceReload) {
        return apiClient.a((BaseImplementation.a)new LoadScoresImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b((BaseImplementation.b<Leaderboards.LoadScoresResult>)this, leaderboardId, span, leaderboardCollection, maxResults, forceReload);
            }
        });
    }

    @Override
    public PendingResult<Leaderboards.LoadScoresResult> loadMoreScores(GoogleApiClient apiClient, final LeaderboardScoreBuffer buffer, final int maxResults, final int pageDirection) {
        return apiClient.a((BaseImplementation.a)new LoadScoresImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<Leaderboards.LoadScoresResult>)this, buffer, maxResults, pageDirection);
            }
        });
    }

    @Override
    public void submitScore(GoogleApiClient apiClient, String leaderboardId, long score) {
        this.submitScore(apiClient, leaderboardId, score, null);
    }

    @Override
    public void submitScore(GoogleApiClient apiClient, String leaderboardId, long score, String scoreTag) {
        Games.d(apiClient).a(null, leaderboardId, score, scoreTag);
    }

    @Override
    public PendingResult<Leaderboards.SubmitScoreResult> submitScoreImmediate(GoogleApiClient apiClient, String leaderboardId, long score) {
        return this.submitScoreImmediate(apiClient, leaderboardId, score, null);
    }

    @Override
    public PendingResult<Leaderboards.SubmitScoreResult> submitScoreImmediate(GoogleApiClient apiClient, final String leaderboardId, final long score, final String scoreTag) {
        return apiClient.b((BaseImplementation.a)new SubmitScoreImpl(apiClient){

            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.a((BaseImplementation.b<Leaderboards.SubmitScoreResult>)this, leaderboardId, score, scoreTag);
            }
        });
    }

    protected static abstract class SubmitScoreImpl
    extends Games.BaseGamesApiMethodImpl<Leaderboards.SubmitScoreResult> {
        protected SubmitScoreImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Leaderboards.SubmitScoreResult X(final Status status) {
            return new Leaderboards.SubmitScoreResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public ScoreSubmissionData getScoreData() {
                    return new ScoreSubmissionData(DataHolder.av((int)14));
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.X(status);
        }
    }

    private static abstract class LoadScoresImpl
    extends Games.BaseGamesApiMethodImpl<Leaderboards.LoadScoresResult> {
        private LoadScoresImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Leaderboards.LoadScoresResult W(final Status status) {
            return new Leaderboards.LoadScoresResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public Leaderboard getLeaderboard() {
                    return null;
                }

                @Override
                public LeaderboardScoreBuffer getScores() {
                    return new LeaderboardScoreBuffer(DataHolder.av((int)14));
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.W(status);
        }
    }

    private static abstract class LoadPlayerScoreImpl
    extends Games.BaseGamesApiMethodImpl<Leaderboards.LoadPlayerScoreResult> {
        private LoadPlayerScoreImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Leaderboards.LoadPlayerScoreResult V(final Status status) {
            return new Leaderboards.LoadPlayerScoreResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public LeaderboardScore getScore() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.V(status);
        }
    }

    private static abstract class LoadMetadataImpl
    extends Games.BaseGamesApiMethodImpl<Leaderboards.LeaderboardMetadataResult> {
        private LoadMetadataImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Leaderboards.LeaderboardMetadataResult U(final Status status) {
            return new Leaderboards.LeaderboardMetadataResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public LeaderboardBuffer getLeaderboards() {
                    return new LeaderboardBuffer(DataHolder.av((int)14));
                }
            };
        }

        public /* synthetic */ Result c(Status status) {
            return this.U(status);
        }
    }
}

