/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.net.LocalSocket;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class RealTimeSocketImpl
implements RealTimeSocket {
    private final LocalSocket ZV;
    private final String Zk;
    private ParcelFileDescriptor LG;

    RealTimeSocketImpl(LocalSocket localSocket, String participantId) {
        this.ZV = localSocket;
        this.Zk = participantId;
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() throws IOException {
        if (this.LG == null && !this.isClosed()) {
            Parcel parcel = Parcel.obtain();
            parcel.writeFileDescriptor(this.ZV.getFileDescriptor());
            parcel.setDataPosition(0);
            this.LG = parcel.readFileDescriptor();
        }
        return this.LG;
    }

    @Override
    public void close() throws IOException {
        this.ZV.close();
    }

    @Override
    public boolean isClosed() {
        return !this.ZV.isConnected() && !this.ZV.isBound();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.ZV.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.ZV.getOutputStream();
    }
}

