/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int CK;
    private final String Ye;
    private final String mName;
    private final String UO;
    private final Uri WD;
    private final String WO;
    private final PlayerEntity XE;
    private final long Yf;
    private final String Yg;
    private final boolean Yh;

    public EventEntity(Event event) {
        this.CK = 1;
        this.Ye = event.getEventId();
        this.mName = event.getName();
        this.UO = event.getDescription();
        this.WD = event.getIconImageUri();
        this.WO = event.getIconImageUrl();
        this.XE = (PlayerEntity)event.getPlayer().freeze();
        this.Yf = event.getValue();
        this.Yg = event.getFormattedValue();
        this.Yh = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.CK = versionCode;
        this.Ye = eventId;
        this.mName = name;
        this.UO = description;
        this.WD = iconImageUri;
        this.WO = iconImageUrl;
        this.XE = new PlayerEntity(player);
        this.Yf = value;
        this.Yg = formattedValue;
        this.Yh = isVisible;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getEventId() {
        return this.Ye;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        le.b((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b((String)this.UO, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.WD;
    }

    @Override
    public String getIconImageUrl() {
        return this.WO;
    }

    @Override
    public Player getPlayer() {
        return this.XE;
    }

    @Override
    public long getValue() {
        return this.Yf;
    }

    @Override
    public String getFormattedValue() {
        return this.Yg;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        le.b((String)this.Yg, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.Yh;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.a(this);
    }

    static int a(Event event) {
        return jv.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object obj) {
        return EventEntity.a(this, obj);
    }

    static boolean a(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return jv.equal((Object)event2.getEventId(), (Object)event.getEventId()) && jv.equal((Object)event2.getName(), (Object)event.getName()) && jv.equal((Object)event2.getDescription(), (Object)event.getDescription()) && jv.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && jv.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && jv.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && jv.equal((Object)event2.getValue(), (Object)event.getValue()) && jv.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && jv.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.b(this);
    }

    static String b(Event event) {
        return jv.h((Object)event).a("Id", (Object)event.getEventId()).a("Name", (Object)event.getName()).a("Description", (Object)event.getDescription()).a("IconImageUri", (Object)event.getIconImageUri()).a("IconImageUrl", (Object)event.getIconImageUrl()).a("Player", (Object)event.getPlayer()).a("Value", (Object)event.getValue()).a("FormattedValue", (Object)event.getFormattedValue()).a("isVisible", (Object)event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.a(this, out, flags);
    }
}

