/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.je;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final AchievementEntityCreator CREATOR = new AchievementEntityCreator();
    private final int CK;
    private final String Xx;
    private final int Gt;
    private final String mName;
    private final String UO;
    private final Uri Xy;
    private final String Xz;
    private final Uri XA;
    private final String XB;
    private final int XC;
    private final String XD;
    private final PlayerEntity XE;
    private final int mState;
    private final int XF;
    private final String XG;
    private final long XH;
    private final long XI;

    public AchievementEntity(Achievement achievement) {
        this.CK = 1;
        this.Xx = achievement.getAchievementId();
        this.Gt = achievement.getType();
        this.mName = achievement.getName();
        this.UO = achievement.getDescription();
        this.Xy = achievement.getUnlockedImageUri();
        this.Xz = achievement.getUnlockedImageUrl();
        this.XA = achievement.getRevealedImageUri();
        this.XB = achievement.getRevealedImageUrl();
        this.XE = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.XH = achievement.getLastUpdatedTimestamp();
        this.XI = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.XC = achievement.getTotalSteps();
            this.XD = achievement.getFormattedTotalSteps();
            this.XF = achievement.getCurrentSteps();
            this.XG = achievement.getFormattedCurrentSteps();
        } else {
            this.XC = 0;
            this.XD = null;
            this.XF = 0;
            this.XG = null;
        }
        je.f((Object)this.Xx);
        je.f((Object)this.UO);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.CK = versionCode;
        this.Xx = achievementId;
        this.Gt = type;
        this.mName = name;
        this.UO = description;
        this.Xy = unlockedImageUri;
        this.Xz = unlockedImageUrl;
        this.XA = revealedImageUri;
        this.XB = revealedImageUrl;
        this.XC = totalSteps;
        this.XD = formattedTotalSteps;
        this.XE = player;
        this.mState = state;
        this.XF = currentSteps;
        this.XG = formattedCurrentSteps;
        this.XH = lastUpdatedTimestamp;
        this.XI = xpValue;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getAchievementId() {
        return this.Xx;
    }

    @Override
    public int getType() {
        return this.Gt;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        le.b((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b((String)this.UO, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.Xy;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.Xz;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.XA;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.XB;
    }

    @Override
    public int getTotalSteps() {
        return this.XC;
    }

    @Override
    public String getFormattedTotalSteps() {
        return this.XD;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        le.b((String)this.XD, (CharArrayBuffer)dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.XE;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        return this.XF;
    }

    @Override
    public String getFormattedCurrentSteps() {
        return this.XG;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        le.b((String)this.XG, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.XH;
    }

    @Override
    public long getXpValue() {
        return this.XI;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.a(this);
    }

    static int a(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return jv.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object obj) {
        return AchievementEntity.a(this, obj);
    }

    static boolean a(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = jv.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = jv.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return jv.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && jv.equal((Object)achievement2.getName(), (Object)achievement.getName()) && jv.equal((Object)achievement2.getType(), (Object)achievement.getType()) && jv.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && jv.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && jv.equal((Object)achievement2.getState(), (Object)achievement.getState()) && jv.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && jv.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.b(this);
    }

    static String b(Achievement achievement) {
        jv.a a2 = jv.h((Object)achievement).a("Id", (Object)achievement.getAchievementId()).a("Type", (Object)achievement.getType()).a("Name", (Object)achievement.getName()).a("Description", (Object)achievement.getDescription()).a("Player", (Object)achievement.getPlayer()).a("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            a2.a("CurrentSteps", (Object)achievement.getCurrentSteps());
            a2.a("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return a2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.a(this, dest, flags);
    }
}

