/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends d
implements Player {
    private final PlayerColumnNames Xv;
    private final PlayerLevelInfo Xm;
    private final MostRecentGameInfoRef Xw;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.Xv = new PlayerColumnNames(prefix);
        this.Xw = new MostRecentGameInfoRef(holder, dataRow, this.Xv);
        if (this.kG()) {
            PlayerLevel playerLevel;
            int n = this.getInteger(this.Xv.acV);
            int n2 = this.getInteger(this.Xv.acY);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n, this.getLong(this.Xv.acW), this.getLong(this.Xv.acX));
            if (n != n2) {
                playerLevel2 = new PlayerLevel(n2, this.getLong(this.Xv.acX), this.getLong(this.Xv.acZ));
            }
            this.Xm = new PlayerLevelInfo(this.getLong(this.Xv.acU), this.getLong(this.Xv.ada), playerLevel, playerLevel2);
        } else {
            this.Xm = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.Xv.acL);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.Xv.acM);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.a(this.Xv.acM, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.aR(this.Xv.acN);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.Xv.acO);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.aR(this.Xv.acP);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.Xv.acQ);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.Xv.acR);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.aQ(this.Xv.acT) || this.aS(this.Xv.acT)) {
            return -1L;
        }
        return this.getLong(this.Xv.acT);
    }

    @Override
    public int kE() {
        return this.getInteger(this.Xv.acS);
    }

    @Override
    public boolean isProfileVisible() {
        return this.getBoolean(this.Xv.add);
    }

    @Override
    public String getTitle() {
        return this.getString(this.Xv.adb);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.a(this.Xv.adb, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.Xm;
    }

    @Override
    public MostRecentGameInfo kF() {
        if (this.aS(this.Xv.ade)) {
            return null;
        }
        return this.Xw;
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.b(this);
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    public String toString() {
        return PlayerEntity.c(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean kG() {
        if (this.aS(this.Xv.acU)) {
            return false;
        }
        return this.getLong(this.Xv.acU) != -1L;
    }
}

