/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevelCreator;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.jx;

public final class PlayerLevel
implements SafeParcelable {
    public static final PlayerLevelCreator CREATOR = new PlayerLevelCreator();
    private final int CK;
    private final int Xo;
    private final long Xp;
    private final long Xq;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        jx.a((minXp >= 0L ? 1 : 0) != 0, (Object)"Min XP must be positive!");
        jx.a((maxXp > minXp ? 1 : 0) != 0, (Object)"Max XP must be more than min XP!");
        this.CK = versionCode;
        this.Xo = levelNumber;
        this.Xp = minXp;
        this.Xq = maxXp;
    }

    public int getVersionCode() {
        return this.CK;
    }

    public int getLevelNumber() {
        return this.Xo;
    }

    public long getMinXp() {
        return this.Xp;
    }

    public long getMaxXp() {
        return this.Xq;
    }

    public int hashCode() {
        return jv.hashCode((Object[])new Object[]{this.Xo, this.Xp, this.Xq});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return jv.equal((Object)playerLevel.getLevelNumber(), (Object)this.getLevelNumber()) && jv.equal((Object)playerLevel.getMinXp(), (Object)this.getMinXp()) && jv.equal((Object)playerLevel.getMaxXp(), (Object)this.getMaxXp());
    }

    public String toString() {
        return jv.h((Object)this).a("LevelNumber", (Object)this.getLevelNumber()).a("MinXp", (Object)this.getMinXp()).a("MaxXp", (Object)this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.a(this, out, flags);
    }
}

