/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.je;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int CK;
    private final String Xh;
    private final String OS;
    private final Uri WD;
    private final Uri WE;
    private final long Xi;
    private final int Xj;
    private final long Xk;
    private final String WO;
    private final String WP;
    private final String OH;
    private final MostRecentGameInfoEntity Xl;
    private final PlayerLevelInfo Xm;
    private final boolean Xn;

    public PlayerEntity(Player player) {
        this.CK = 11;
        this.Xh = player.getPlayerId();
        this.OS = player.getDisplayName();
        this.WD = player.getIconImageUri();
        this.WO = player.getIconImageUrl();
        this.WE = player.getHiResImageUri();
        this.WP = player.getHiResImageUrl();
        this.Xi = player.getRetrievedTimestamp();
        this.Xj = player.kE();
        this.Xk = player.getLastPlayedWithTimestamp();
        this.OH = player.getTitle();
        this.Xn = player.isProfileVisible();
        MostRecentGameInfo mostRecentGameInfo = player.kF();
        this.Xl = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.Xm = player.getLevelInfo();
        je.f((Object)this.Xh);
        je.f((Object)this.OS);
        je.K((this.Xi > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible) {
        this.CK = versionCode;
        this.Xh = playerId;
        this.OS = displayName;
        this.WD = iconImageUri;
        this.WO = iconImageUrl;
        this.WE = hiResImageUri;
        this.WP = hiResImageUrl;
        this.Xi = retrievedTimestamp;
        this.Xj = isInCircles;
        this.Xk = lastPlayedWithTimestamp;
        this.OH = title;
        this.Xn = isProfileVisible;
        this.Xl = mostRecentGameInfo;
        this.Xm = playerLevelInfo;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getPlayerId() {
        return this.Xh;
    }

    @Override
    public String getDisplayName() {
        return this.OS;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        le.b((String)this.OS, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.WD;
    }

    @Override
    public String getIconImageUrl() {
        return this.WO;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.WE;
    }

    @Override
    public String getHiResImageUrl() {
        return this.WP;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.Xi;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.Xk;
    }

    @Override
    public int kE() {
        return this.Xj;
    }

    @Override
    public boolean isProfileVisible() {
        return this.Xn;
    }

    @Override
    public String getTitle() {
        return this.OH;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        le.b((String)this.OH, (CharArrayBuffer)dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.Xm;
    }

    @Override
    public MostRecentGameInfo kF() {
        return this.Xl;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.b(this);
    }

    static int b(Player player) {
        return jv.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo()});
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return jv.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && jv.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && jv.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && jv.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && jv.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && jv.equal((Object)player2.getTitle(), (Object)player.getTitle()) && jv.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.c(this);
    }

    static String c(Player player) {
        return jv.h((Object)player).a("PlayerId", (Object)player.getPlayerId()).a("DisplayName", (Object)player.getDisplayName()).a("IconImageUri", (Object)player.getIconImageUri()).a("IconImageUrl", (Object)player.getIconImageUrl()).a("HiResImageUri", (Object)player.getHiResImageUri()).a("HiResImageUrl", (Object)player.getHiResImageUrl()).a("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).a("Title", (Object)player.getTitle()).a("LevelInfo", (Object)player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            PlayerEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Xh);
            dest.writeString(this.OS);
            dest.writeString(this.WD == null ? null : this.WD.toString());
            dest.writeString(this.WE == null ? null : this.WE.toString());
            dest.writeLong(this.Xi);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity cm(Parcel parcel) {
            boolean bl = PlayerEntity.c(PlayerEntity.ht());
            if (bl || PlayerEntity.aW((String)PlayerEntity.class.getCanonicalName())) {
                return super.cm(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            int n = -1;
            long l2 = -1L;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl2 = true;
            return new PlayerEntity(11, string, string2, uri, uri2, l, n, l2, string5, string6, string7, mostRecentGameInfoEntity, playerLevelInfo, bl2);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cm(x0);
        }
    }
}

