/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.jv;
import com.google.android.gms.internal.le;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int CK;
    private final String Fo;
    private final String OS;
    private final String WA;
    private final String WB;
    private final String UO;
    private final String WC;
    private final Uri WD;
    private final Uri WE;
    private final Uri WF;
    private final boolean WG;
    private final boolean WH;
    private final String WI;
    private final int WJ;
    private final int WK;
    private final int WL;
    private final boolean WM;
    private final boolean WN;
    private final String WO;
    private final String WP;
    private final String WQ;
    private final boolean WR;
    private final boolean WS;
    private final boolean WT;
    private final String WU;

    public GameEntity(Game game) {
        this.CK = 5;
        this.Fo = game.getApplicationId();
        this.WA = game.getPrimaryCategory();
        this.WB = game.getSecondaryCategory();
        this.UO = game.getDescription();
        this.WC = game.getDeveloperName();
        this.OS = game.getDisplayName();
        this.WD = game.getIconImageUri();
        this.WO = game.getIconImageUrl();
        this.WE = game.getHiResImageUri();
        this.WP = game.getHiResImageUrl();
        this.WF = game.getFeaturedImageUri();
        this.WQ = game.getFeaturedImageUrl();
        this.WG = game.ky();
        this.WH = game.kA();
        this.WI = game.kB();
        this.WJ = game.kC();
        this.WK = game.getAchievementTotalCount();
        this.WL = game.getLeaderboardCount();
        this.WM = game.isRealTimeMultiplayerEnabled();
        this.WN = game.isTurnBasedMultiplayerEnabled();
        this.WR = game.isMuted();
        this.WS = game.kz();
        this.WT = game.areSnapshotsEnabled();
        this.WU = game.getThemeColor();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor) {
        this.CK = versionCode;
        this.Fo = applicationId;
        this.OS = displayName;
        this.WA = primaryCategory;
        this.WB = secondaryCategory;
        this.UO = description;
        this.WC = developerName;
        this.WD = iconImageUri;
        this.WO = iconImageUrl;
        this.WE = hiResImageUri;
        this.WP = hiResImageUrl;
        this.WF = featuredImageUri;
        this.WQ = featuredImageUrl;
        this.WG = playEnabledGame;
        this.WH = instanceInstalled;
        this.WI = instancePackageName;
        this.WJ = gameplayAclStatus;
        this.WK = achievementTotalCount;
        this.WL = leaderboardCount;
        this.WM = realTimeEnabled;
        this.WN = turnBasedEnabled;
        this.WR = muted;
        this.WS = identitySharingConfirmed;
        this.WT = snapshotsEnabled;
        this.WU = themeColor;
    }

    public int getVersionCode() {
        return this.CK;
    }

    @Override
    public String getApplicationId() {
        return this.Fo;
    }

    @Override
    public String getDisplayName() {
        return this.OS;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        le.b((String)this.OS, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.WA;
    }

    @Override
    public String getSecondaryCategory() {
        return this.WB;
    }

    @Override
    public String getDescription() {
        return this.UO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        le.b((String)this.UO, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.WC;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        le.b((String)this.WC, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.WD;
    }

    @Override
    public String getIconImageUrl() {
        return this.WO;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.WE;
    }

    @Override
    public String getHiResImageUrl() {
        return this.WP;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.WF;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.WQ;
    }

    @Override
    public boolean isMuted() {
        return this.WR;
    }

    @Override
    public boolean kz() {
        return this.WS;
    }

    @Override
    public boolean ky() {
        return this.WG;
    }

    @Override
    public boolean kA() {
        return this.WH;
    }

    @Override
    public String kB() {
        return this.WI;
    }

    @Override
    public int kC() {
        return this.WJ;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.WK;
    }

    @Override
    public int getLeaderboardCount() {
        return this.WL;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.WM;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.WN;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.WT;
    }

    @Override
    public String getThemeColor() {
        return this.WU;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return jv.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.ky(), game.kA(), game.kB(), game.kC(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.kz(), game.areSnapshotsEnabled(), game.getThemeColor()});
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return jv.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && jv.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && jv.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && jv.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && jv.equal((Object)game2.getDescription(), (Object)game.getDescription()) && jv.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && jv.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && jv.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && jv.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && jv.equal((Object)game2.ky(), (Object)game.ky()) && jv.equal((Object)game2.kA(), (Object)game.kA()) && jv.equal((Object)game2.kB(), (Object)game.kB()) && jv.equal((Object)game2.kC(), (Object)game.kC()) && jv.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && jv.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && jv.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && jv.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && jv.equal((Object)game2.isMuted(), (Object)game.isMuted()) && jv.equal((Object)game2.kz(), (Object)game.kz()) ? 1 : 0)) && jv.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && jv.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return jv.h((Object)game).a("ApplicationId", (Object)game.getApplicationId()).a("DisplayName", (Object)game.getDisplayName()).a("PrimaryCategory", (Object)game.getPrimaryCategory()).a("SecondaryCategory", (Object)game.getSecondaryCategory()).a("Description", (Object)game.getDescription()).a("DeveloperName", (Object)game.getDeveloperName()).a("IconImageUri", (Object)game.getIconImageUri()).a("IconImageUrl", (Object)game.getIconImageUrl()).a("HiResImageUri", (Object)game.getHiResImageUri()).a("HiResImageUrl", (Object)game.getHiResImageUrl()).a("FeaturedImageUri", (Object)game.getFeaturedImageUri()).a("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).a("PlayEnabledGame", (Object)game.ky()).a("InstanceInstalled", (Object)game.kA()).a("InstancePackageName", (Object)game.kB()).a("AchievementTotalCount", (Object)game.getAchievementTotalCount()).a("LeaderboardCount", (Object)game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).a("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).a("ThemeColor", (Object)game.getThemeColor()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hu()) {
            GameEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Fo);
            dest.writeString(this.OS);
            dest.writeString(this.WA);
            dest.writeString(this.WB);
            dest.writeString(this.UO);
            dest.writeString(this.WC);
            dest.writeString(this.WD == null ? null : this.WD.toString());
            dest.writeString(this.WE == null ? null : this.WE.toString());
            dest.writeString(this.WF == null ? null : this.WF.toString());
            dest.writeInt(this.WG ? 1 : 0);
            dest.writeInt(this.WH ? 1 : 0);
            dest.writeString(this.WI);
            dest.writeInt(this.WJ);
            dest.writeInt(this.WK);
            dest.writeInt(this.WL);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity cl(Parcel parcel) {
            boolean bl = GameEntity.c(GameEntity.ht());
            if (bl || GameEntity.aW((String)GameEntity.class.getCanonicalName())) {
                return super.cl(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string14 = null;
            return new GameEntity(5, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, bl4, bl5, string11, string12, string13, bl6, bl7, bl8, string14);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cl(x0);
        }
    }
}

