/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.SessionDataSet;
import com.google.android.gms.fitness.result.zzj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SessionReadResult
implements Result,
SafeParcelable {
    private final int zzCY;
    private final List<Session> zzalQ;
    private final List<SessionDataSet> zzamX;
    private final Status zzOt;
    public static final Parcelable.Creator<SessionReadResult> CREATOR = new zzj();

    SessionReadResult(int versionCode, List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.zzCY = versionCode;
        this.zzalQ = sessions;
        this.zzamX = Collections.unmodifiableList(sessionDataSets);
        this.zzOt = status;
    }

    public SessionReadResult(List<Session> sessions, List<SessionDataSet> sessionDataSets, Status status) {
        this.zzCY = 3;
        this.zzalQ = sessions;
        this.zzamX = Collections.unmodifiableList(sessionDataSets);
        this.zzOt = status;
    }

    public static SessionReadResult zzO(Status status) {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        ArrayList<SessionDataSet> arrayList2 = new ArrayList<SessionDataSet>();
        return new SessionReadResult(arrayList, arrayList2, status);
    }

    public List<Session> getSessions() {
        return this.zzalQ;
    }

    public List<DataSet> getDataSet(Session session, DataType dataType) {
        zzu.zzb((boolean)this.zzalQ.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzamX) {
            if (!zzt.equal((Object)session, (Object)sessionDataSet.getSession()) || !dataType.equals(sessionDataSet.zzqK().getDataType())) continue;
            arrayList.add(sessionDataSet.zzqK());
        }
        return arrayList;
    }

    public List<DataSet> getDataSet(Session session) {
        zzu.zzb((boolean)this.zzalQ.contains(session), (String)"Attempting to read data for session %s which was not returned", (Object[])new Object[]{session});
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (SessionDataSet sessionDataSet : this.zzamX) {
            if (!zzt.equal((Object)session, (Object)sessionDataSet.getSession())) continue;
            arrayList.add(sessionDataSet.zzqK());
        }
        return arrayList;
    }

    public List<SessionDataSet> zzry() {
        return this.zzamX;
    }

    public Status getStatus() {
        return this.zzOt;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SessionReadResult && this.zzb((SessionReadResult)that);
    }

    private boolean zzb(SessionReadResult sessionReadResult) {
        return this.zzOt.equals((Object)sessionReadResult.zzOt) && zzt.equal(this.zzalQ, sessionReadResult.zzalQ) && zzt.equal(this.zzamX, sessionReadResult.zzamX);
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzOt, this.zzalQ, this.zzamX});
    }

    public String toString() {
        return zzt.zzt((Object)this).zzg("status", (Object)this.zzOt).zzg("sessions", this.zzalQ).zzg("sessionDataSets", this.zzamX).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }
}

