/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzv;
import com.google.android.gms.internal.zzms;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int zzCY;
    private final String zzamE;
    private final String zzFE;
    private final long zzKT;
    private final long zzajH;
    private final List<DataType> zzajQ;
    private final List<DataSource> zzalP;
    private boolean zzamF;
    private final boolean zzama;
    private final List<String> zzamG;
    private final zzms zzamH;
    private final String zzMZ;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new zzv();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, IBinder callback, String packageName) {
        this.zzCY = versionCode;
        this.zzamE = sessionName;
        this.zzFE = sessionId;
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.zzajQ = Collections.unmodifiableList(dataTypes);
        this.zzalP = Collections.unmodifiableList(dataSources);
        this.zzamF = getSessionsFromAllApps;
        this.zzama = serverQueriesEnabled;
        this.zzamG = excludedPackages;
        this.zzamH = callback == null ? null : zzms.zza.zzbD(callback);
        this.zzMZ = packageName;
    }

    private SessionReadRequest(Builder builder) {
        this(builder.zzamE, builder.zzFE, builder.zzKT, builder.zzajH, builder.zzajQ, builder.zzalP, builder.zzamF, builder.zzama, builder.zzamG, null, null);
    }

    public SessionReadRequest(SessionReadRequest request, zzms callback, String packageName) {
        this(request.zzamE, request.zzFE, request.zzKT, request.zzajH, request.zzajQ, request.zzalP, request.zzamF, request.zzama, request.zzamG, callback, packageName);
    }

    public SessionReadRequest(String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages, zzms callback, String packageName) {
        this.zzCY = 4;
        this.zzamE = sessionName;
        this.zzFE = sessionId;
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.zzajQ = Collections.unmodifiableList(dataTypes);
        this.zzalP = Collections.unmodifiableList(dataSources);
        this.zzamF = getSessionsFromAllApps;
        this.zzama = serverQueriesEnabled;
        this.zzamG = excludedPackages;
        this.zzamH = callback;
        this.zzMZ = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzKT, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzajH, TimeUnit.MILLISECONDS);
    }

    public String getSessionName() {
        return this.zzamE;
    }

    public String getSessionId() {
        return this.zzFE;
    }

    public List<DataType> getDataTypes() {
        return this.zzajQ;
    }

    public List<DataSource> getDataSources() {
        return this.zzalP;
    }

    public boolean includeSessionsFromAllApps() {
        return this.zzamF;
    }

    public List<String> getExcludedPackages() {
        return this.zzamG;
    }

    public boolean zzqZ() {
        return this.zzama;
    }

    public long zzqs() {
        return this.zzajH;
    }

    public long zzkt() {
        return this.zzKT;
    }

    public boolean zzro() {
        return this.zzamF;
    }

    public IBinder zzqU() {
        return this.zzamH == null ? null : this.zzamH.asBinder();
    }

    public String getPackageName() {
        return this.zzMZ;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof SessionReadRequest && this.zzb((SessionReadRequest)o);
    }

    private boolean zzb(SessionReadRequest sessionReadRequest) {
        return zzt.equal((Object)this.zzamE, (Object)sessionReadRequest.zzamE) && this.zzFE.equals(sessionReadRequest.zzFE) && this.zzKT == sessionReadRequest.zzKT && this.zzajH == sessionReadRequest.zzajH && zzt.equal(this.zzajQ, sessionReadRequest.zzajQ) && zzt.equal(this.zzalP, sessionReadRequest.zzalP) && this.zzamF == sessionReadRequest.zzamF && this.zzamG.equals(sessionReadRequest.zzamG) && this.zzama == sessionReadRequest.zzama;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzamE, this.zzFE, this.zzKT, this.zzajH});
    }

    public String toString() {
        return zzt.zzt((Object)this).zzg("sessionName", (Object)this.zzamE).zzg("sessionId", (Object)this.zzFE).zzg("startTimeMillis", (Object)this.zzKT).zzg("endTimeMillis", (Object)this.zzajH).zzg("dataTypes", this.zzajQ).zzg("dataSources", this.zzalP).zzg("sessionsFromAllApps", (Object)this.zzamF).zzg("excludedPackages", this.zzamG).zzg("useServer", (Object)this.zzama).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzv.zza(this, dest, flags);
    }

    public static class Builder {
        private String zzamE;
        private String zzFE;
        private long zzKT = 0L;
        private long zzajH = 0L;
        private List<DataType> zzajQ = new ArrayList<DataType>();
        private List<DataSource> zzalP = new ArrayList<DataSource>();
        private boolean zzamF = false;
        private boolean zzama = false;
        private List<String> zzamG = new ArrayList<String>();

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            this.zzKT = timeUnit.toMillis(startTime);
            this.zzajH = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder setSessionName(String sessionName) {
            this.zzamE = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.zzFE = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            zzu.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            if (!this.zzalP.contains(dataSource)) {
                this.zzalP.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzu.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            if (!this.zzajQ.contains(dataType)) {
                this.zzajQ.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.zzamF = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            zzu.zzb((Object)appPackageName, (Object)"Attempting to use a null package name");
            if (!this.zzamG.contains(appPackageName)) {
                this.zzamG.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.zzama = true;
            return this;
        }

        public SessionReadRequest build() {
            zzu.zzb((this.zzKT > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzKT});
            zzu.zzb((this.zzajH > 0L && this.zzajH > this.zzKT ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzajH});
            return new SessionReadRequest(this);
        }
    }
}

