/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.request.zzf;
import com.google.android.gms.internal.zzmf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    public static final int NO_LIMIT = 0;
    private final int zzCY;
    private final List<DataType> zzajQ;
    private final List<DataSource> zzalP;
    private final long zzKT;
    private final long zzajH;
    private final List<DataType> zzalU;
    private final List<DataSource> zzalV;
    private final int zzajT;
    private final long zzalW;
    private final DataSource zzalX;
    private final int zzalY;
    private final boolean zzalZ;
    private final boolean zzama;
    private final zzmf zzamb;
    private final String zzMZ;
    private final List<Device> zzamc;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new zzf();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, IBinder callback, String packageName, List<Device> filteredDevices) {
        this.zzCY = versionCode;
        this.zzajQ = Collections.unmodifiableList(dataTypes);
        this.zzalP = Collections.unmodifiableList(dataSources);
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.zzalU = Collections.unmodifiableList(aggregatedDataTypes);
        this.zzalV = Collections.unmodifiableList(aggregatedDataSources);
        this.zzajT = bucketType;
        this.zzalW = bucketDurationMillis;
        this.zzalX = activityDataSource;
        this.zzalY = limit;
        this.zzalZ = flushBeforeRead;
        this.zzama = serverQueriesEnabled;
        this.zzamb = callback == null ? null : zzmf.zza.zzbq(callback);
        this.zzMZ = packageName;
        this.zzamc = filteredDevices == null ? Collections.EMPTY_LIST : filteredDevices;
    }

    private DataReadRequest(Builder builder) {
        this(builder.zzajQ, builder.zzalP, builder.zzKT, builder.zzajH, builder.zzalU, builder.zzalV, builder.zzajT, builder.zzalW, builder.zzalX, builder.zzalY, builder.zzalZ, builder.zzama, null, null, builder.zzamc);
    }

    public DataReadRequest(DataReadRequest request, zzmf callback, String packageName) {
        this(request.zzajQ, request.zzalP, request.zzKT, request.zzajH, request.zzalU, request.zzalV, request.zzajT, request.zzalW, request.zzalX, request.zzalY, request.zzalZ, request.zzama, callback, packageName, request.zzamc);
    }

    public DataReadRequest(List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean flushBeforeRead, boolean serverQueriesEnabled, zzmf callback, String packageName, List<Device> filteredDevices) {
        this.zzCY = 4;
        this.zzajQ = Collections.unmodifiableList(dataTypes);
        this.zzalP = Collections.unmodifiableList(dataSources);
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.zzalU = Collections.unmodifiableList(aggregatedDataTypes);
        this.zzalV = Collections.unmodifiableList(aggregatedDataSources);
        this.zzajT = bucketType;
        this.zzalW = bucketDurationMillis;
        this.zzalX = activityDataSource;
        this.zzalY = limit;
        this.zzalZ = flushBeforeRead;
        this.zzama = serverQueriesEnabled;
        this.zzamb = callback;
        this.zzMZ = packageName;
        this.zzamc = filteredDevices;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzKT, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzajH, TimeUnit.MILLISECONDS);
    }

    public List<DataType> getDataTypes() {
        return this.zzajQ;
    }

    public List<DataSource> getDataSources() {
        return this.zzalP;
    }

    public List<DataType> getAggregatedDataTypes() {
        return this.zzalU;
    }

    public List<DataSource> getAggregatedDataSources() {
        return this.zzalV;
    }

    public int getBucketType() {
        return this.zzajT;
    }

    public long getBucketDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzalW, TimeUnit.MILLISECONDS);
    }

    public DataSource getActivityDataSource() {
        return this.zzalX;
    }

    public int getLimit() {
        return this.zzalY;
    }

    public boolean zzqZ() {
        return this.zzama;
    }

    public boolean zzra() {
        return this.zzalZ;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.zzb((DataReadRequest)that);
    }

    private boolean zzb(DataReadRequest dataReadRequest) {
        return this.zzajQ.equals(dataReadRequest.zzajQ) && this.zzalP.equals(dataReadRequest.zzalP) && this.zzKT == dataReadRequest.zzKT && this.zzajH == dataReadRequest.zzajH && this.zzajT == dataReadRequest.zzajT && this.zzalV.equals(dataReadRequest.zzalV) && this.zzalU.equals(dataReadRequest.zzalU) && zzt.equal((Object)this.zzalX, (Object)dataReadRequest.zzalX) && this.zzalW == dataReadRequest.zzalW && this.zzama == dataReadRequest.zzama;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzajT, this.zzKT, this.zzajH});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataReadRequest{");
        if (!this.zzajQ.isEmpty()) {
            for (DataType object : this.zzajQ) {
                stringBuilder.append(object.zzqD()).append(" ");
            }
        }
        if (!this.zzalP.isEmpty()) {
            for (DataSource dataSource : this.zzalP) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.zzajT != 0) {
            stringBuilder.append("bucket by ").append(Bucket.zzeb(this.zzajT));
            if (this.zzalW > 0L) {
                stringBuilder.append(" >").append(this.zzalW).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.zzalU.isEmpty()) {
            for (DataType dataType : this.zzalU) {
                stringBuilder.append(dataType.zzqD()).append(" ");
            }
        }
        if (!this.zzalV.isEmpty()) {
            for (DataSource dataSource : this.zzalV) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.zzKT, this.zzKT, this.zzajH, this.zzajH));
        if (this.zzalX != null) {
            stringBuilder.append("activities: ").append(this.zzalX.toDebugString());
        }
        if (this.zzama) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public long zzqs() {
        return this.zzajH;
    }

    public long zzkt() {
        return this.zzKT;
    }

    public long zzrb() {
        return this.zzalW;
    }

    public IBinder zzqU() {
        return this.zzamb == null ? null : this.zzamb.asBinder();
    }

    public String getPackageName() {
        return this.zzMZ;
    }

    public List<Device> zzrc() {
        return this.zzamc;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzf.zza(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> zzajQ = new ArrayList<DataType>();
        private List<DataSource> zzalP = new ArrayList<DataSource>();
        private List<DataType> zzalU = new ArrayList<DataType>();
        private List<DataSource> zzalV = new ArrayList<DataSource>();
        private DataSource zzalX;
        private long zzKT;
        private long zzajH;
        private int zzajT = 0;
        private long zzalW = 0L;
        private int zzalY = 0;
        private boolean zzalZ = false;
        private boolean zzama = false;
        private List<Device> zzamc = new ArrayList<Device>();

        public Builder read(DataSource dataSource) {
            zzu.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzu.zzb((!this.zzalV.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.zzalP.contains(dataSource)) {
                this.zzalP.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            zzu.zzb((Object)dataType, (Object)"Attempting to use a null data type");
            zzu.zza((!this.zzalU.contains(dataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            if (!this.zzajQ.contains(dataType)) {
                this.zzajQ.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            zzu.zzb((Object)dataSource, (Object)"Attempting to add a null data source");
            zzu.zza((!this.zzalP.contains(dataSource) ? 1 : 0) != 0, (Object)"Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            zzu.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(dataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{dataType});
            zzu.zzb((boolean)DataType.getAggregatesForInput(dataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{dataType, outputDataType});
            if (!this.zzalV.contains(dataSource)) {
                this.zzalV.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            zzu.zzb((Object)inputDataType, (Object)"Attempting to use a null data type");
            zzu.zza((!this.zzajQ.contains(inputDataType) ? 1 : 0) != 0, (Object)"Cannot add the same data type as aggregated and detailed");
            zzu.zzb((boolean)DataType.AGGREGATE_INPUT_TYPES.contains(inputDataType), (String)"Unsupported input data type specified for aggregation: %s", (Object[])new Object[]{inputDataType});
            zzu.zzb((boolean)DataType.getAggregatesForInput(inputDataType).contains(outputDataType), (String)"Invalid output aggregate data type specified: %s -> %s", (Object[])new Object[]{inputDataType, outputDataType});
            if (!this.zzalU.contains(inputDataType)) {
                this.zzalU.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            zzu.zzb((this.zzajT == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzajT});
            zzu.zzb((duration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{duration});
            this.zzajT = 1;
            this.zzalW = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            zzu.zzb((this.zzajT == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzajT});
            zzu.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzajT = 3;
            this.zzalW = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzu.zzb((this.zzajT == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzajT});
            zzu.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzu.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzu.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzalX = activityDataSource;
            this.zzajT = 3;
            this.zzalW = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            zzu.zzb((this.zzajT == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzajT});
            zzu.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzajT = 4;
            this.zzalW = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            zzu.zzb((this.zzajT == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzajT});
            zzu.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            zzu.zzb((activityDataSource != null ? 1 : 0) != 0, (Object)"Invalid activity data source specified");
            zzu.zzb((boolean)activityDataSource.getDataType().equals(DataType.TYPE_ACTIVITY_SEGMENT), (String)"Invalid activity data source specified: %s", (Object[])new Object[]{activityDataSource});
            this.zzalX = activityDataSource;
            this.zzajT = 4;
            this.zzalW = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            zzu.zzb((this.zzajT == 0 ? 1 : 0) != 0, (String)"Bucketing strategy already set to %s", (Object[])new Object[]{this.zzajT});
            zzu.zzb((minDuration > 0 ? 1 : 0) != 0, (String)"Must specify a valid minimum duration for an activity segment: %d", (Object[])new Object[]{minDuration});
            this.zzajT = 2;
            this.zzalW = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long start, long end, TimeUnit timeUnit) {
            this.zzKT = timeUnit.toMillis(start);
            this.zzajH = timeUnit.toMillis(end);
            return this;
        }

        public Builder enableServerQueries() {
            this.zzama = true;
            return this;
        }

        public Builder setLimit(int limit) {
            zzu.zzb((limit > 0 ? 1 : 0) != 0, (String)"Invalid limit %d is specified", (Object[])new Object[]{limit});
            this.zzalY = limit;
            return this;
        }

        public DataReadRequest build() {
            zzu.zza((!this.zzalP.isEmpty() || !this.zzajQ.isEmpty() || !this.zzalV.isEmpty() || !this.zzalU.isEmpty() ? 1 : 0) != 0, (Object)"Must add at least one data source (aggregated or detailed)");
            zzu.zza((this.zzKT > 0L ? 1 : 0) != 0, (String)"Invalid start time: %s", (Object[])new Object[]{this.zzKT});
            zzu.zza((this.zzajH > 0L && this.zzajH > this.zzKT ? 1 : 0) != 0, (String)"Invalid end time: %s", (Object[])new Object[]{this.zzajH});
            boolean bl = this.zzalV.isEmpty() && this.zzalU.isEmpty();
            zzu.zza((bl && this.zzajT == 0 || !bl && this.zzajT != 0 ? 1 : 0) != 0, (Object)"Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

