/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.Application;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.zzf;

public class DataSource
implements SafeParcelable {
    public static final String EXTRA_DATA_SOURCE = "vnd.google.fitness.data_source";
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int zzCY;
    private final DataType zzajF;
    private final String mName;
    private final int zzSq;
    private final Device zzakd;
    private final Application zzake;
    private final String zzakf;
    private final String zzakg;
    public static final Parcelable.Creator<DataSource> CREATOR = new zzf();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, Application application, String streamName) {
        this.zzCY = versionCode;
        this.zzajF = dataType;
        this.zzSq = type;
        this.mName = name;
        this.zzakd = device;
        this.zzake = application;
        this.zzakf = streamName;
        this.zzakg = this.zzqC();
    }

    private DataSource(Builder builder) {
        this.zzCY = 3;
        this.zzajF = builder.zzajF;
        this.zzSq = builder.zzSq;
        this.mName = builder.mName;
        this.zzakd = builder.zzakd;
        this.zzake = builder.zzake;
        this.zzakf = builder.zzakf;
        this.zzakg = this.zzqC();
    }

    public static DataSource extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataSource)zzc.zza((Intent)intent, (String)EXTRA_DATA_SOURCE, CREATOR);
    }

    public DataType getDataType() {
        return this.zzajF;
    }

    public int getType() {
        return this.zzSq;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.zzake == null ? null : this.zzake.getPackageName();
    }

    public Application zzqB() {
        return this.zzake;
    }

    public Device getDevice() {
        return this.zzakd;
    }

    public String getStreamName() {
        return this.zzakf;
    }

    public String getStreamIdentifier() {
        return this.zzakg;
    }

    private String zzqC() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.zzajF.getName());
        if (this.zzake != null) {
            stringBuilder.append(":").append(this.zzake.getPackageName());
        }
        if (this.zzakd != null) {
            stringBuilder.append(":").append(this.zzakd.getStreamIdentifier());
        }
        if (this.zzakf != null) {
            stringBuilder.append(":").append(this.zzakf);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.zza((DataSource)that);
    }

    private boolean zza(DataSource dataSource) {
        return this.zzakg.equals(dataSource.zzakg);
    }

    public int hashCode() {
        return this.zzakg.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.zzake != null) {
            stringBuilder.append(":").append(this.zzake);
        }
        if (this.zzakd != null) {
            stringBuilder.append(":").append(this.zzakd);
        }
        if (this.zzakf != null) {
            stringBuilder.append(":").append(this.zzakf);
        }
        stringBuilder.append(":").append(this.zzajF);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.zzSq == 0 ? "r" : "d") + ":" + this.zzajF.zzqD() + (this.zzake == null ? "" : (this.zzake.equals(Application.zzajM) ? ":gms" : ":" + this.zzake.getPackageName())) + (this.zzakd != null ? ":" + this.zzakd.getModel() + ":" + this.zzakd.getUid() : "") + (this.zzakf != null ? ":" + this.zzakf : "");
    }

    private String getTypeString() {
        switch (this.zzSq) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzf.zza(this, parcel, flags);
    }

    public static final class Builder {
        private DataType zzajF;
        private int zzSq = -1;
        private String mName;
        private Device zzakd;
        private Application zzake;
        private String zzakf = "";

        public Builder setDataType(DataType dataType) {
            this.zzajF = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.zzSq = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.zzakd = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.zzake = Application.zzcG(packageName);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            zzu.zzb((streamName != null ? 1 : 0) != 0, (Object)"Must specify a valid stream name");
            this.zzakf = streamName;
            return this;
        }

        public DataSource build() {
            zzu.zza((this.zzajF != null ? 1 : 0) != 0, (Object)"Must set data type");
            zzu.zza((this.zzSq >= 0 ? 1 : 0) != 0, (Object)"Must set data source type");
            return new DataSource(this);
        }
    }
}

