/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
implements SafeParcelable {
    private final int zzCY;
    private final DataSource zzajG;
    private final DataType zzajF;
    private final List<DataPoint> zzakb;
    private final List<DataSource> zzakc;
    private boolean zzajU = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zze();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.zzCY = versionCode;
        this.zzajG = dataSource;
        this.zzajF = dataSource.getDataType();
        this.zzajU = serverHasMoreData;
        this.zzakb = new ArrayList<DataPoint>(dataPoints.size());
        this.zzakc = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.zzakb.add(new DataPoint(this.zzakc, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.zzCY = 3;
        this.zzajG = (DataSource)zzu.zzu((Object)dataSource);
        this.zzajF = dataSource.getDataType();
        this.zzakb = new ArrayList<DataPoint>();
        this.zzakc = new ArrayList<DataSource>();
        this.zzakc.add(this.zzajG);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources) {
        this.zzCY = 3;
        this.zzajG = DataSet.zzb(uniqueDataSources, dataSet.zzakH);
        this.zzajF = this.zzajG.getDataType();
        this.zzakc = uniqueDataSources;
        this.zzajU = dataSet.zzajU;
        List<RawDataPoint> list = dataSet.zzakK;
        this.zzakb = new ArrayList<DataPoint>(list.size());
        for (RawDataPoint rawDataPoint : list) {
            this.zzakb.add(new DataPoint(this.zzakc, rawDataPoint));
        }
    }

    private static <T> T zzb(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzu.zzb((Object)dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzajG);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzu.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzajG.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzajG});
        dataPoint.zzqx();
        this.zzb(dataPoint);
    }

    public void zzb(DataPoint dataPoint) {
        this.zzakb.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzakc.contains(dataSource)) {
            this.zzakc.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzajG;
    }

    public DataType getDataType() {
        return this.zzajG.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzakb);
    }

    public boolean isEmpty() {
        return this.zzakb.isEmpty();
    }

    public boolean zzqr() {
        return this.zzajU;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataSet && this.zza((DataSet)o);
    }

    private boolean zza(DataSet dataSet) {
        return zzt.equal((Object)this.getDataType(), (Object)dataSet.getDataType()) && zzt.equal((Object)this.zzajG, (Object)dataSet.zzajG) && zzt.equal(this.zzakb, dataSet.zzakb) && this.zzajU == dataSet.zzajU;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzajG});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzqz();
        return String.format("DataSet{%s %s}", this.zzajG.toDebugString(), this.zzakb.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzakb.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.zzCY;
    }

    List<RawDataPoint> zzqz() {
        return this.zzk(this.zzakc);
    }

    List<RawDataPoint> zzk(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzakb.size());
        for (DataPoint dataPoint : this.zzakb) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzqA() {
        return this.zzakc;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }
}

