/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Bucket
implements SafeParcelable {
    public static final int TYPE_TIME = 1;
    public static final int TYPE_SESSION = 2;
    public static final int TYPE_ACTIVITY_TYPE = 3;
    public static final int TYPE_ACTIVITY_SEGMENT = 4;
    private final int zzCY;
    private final long zzKT;
    private final long zzajH;
    private final Session zzajJ;
    private final int zzajR;
    private final List<DataSet> zzajS;
    private final int zzajT;
    private boolean zzajU = false;
    public static final Parcelable.Creator<Bucket> CREATOR = new zzc();

    Bucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activityType, List<DataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.zzCY = versionCode;
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.zzajJ = session;
        this.zzajR = activityType;
        this.zzajS = dataSets;
        this.zzajT = bucketType;
        this.zzajU = serverHasMoreData;
    }

    public Bucket(RawBucket bucket, List<DataSource> uniqueDataSources) {
        this(2, bucket.zzKT, bucket.zzajH, bucket.zzajJ, bucket.zzakG, Bucket.zza(bucket.zzajS, uniqueDataSources), bucket.zzajT, bucket.zzajU);
    }

    private static List<DataSet> zza(Collection<RawDataSet> collection, List<DataSource> list) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>(collection.size());
        for (RawDataSet rawDataSet : collection) {
            arrayList.add(new DataSet(rawDataSet, list));
        }
        return arrayList;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzKT, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzajH, TimeUnit.MILLISECONDS);
    }

    public Session getSession() {
        return this.zzajJ;
    }

    public String getActivity() {
        return FitnessActivities.getName(this.zzajR);
    }

    public int zzqq() {
        return this.zzajR;
    }

    public List<DataSet> getDataSets() {
        return this.zzajS;
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzajS) {
            if (!dataSet.getDataType().equals(dataType)) continue;
            return dataSet;
        }
        return null;
    }

    public int getBucketType() {
        return this.zzajT;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Bucket && this.zza((Bucket)o);
    }

    private boolean zza(Bucket bucket) {
        return this.zzKT == bucket.zzKT && this.zzajH == bucket.zzajH && this.zzajR == bucket.zzajR && zzt.equal(this.zzajS, bucket.zzajS) && this.zzajT == bucket.zzajT && this.zzajU == bucket.zzajU;
    }

    public boolean zzb(Bucket bucket) {
        return this.zzKT == bucket.zzKT && this.zzajH == bucket.zzajH && this.zzajR == bucket.zzajR && this.zzajT == bucket.zzajT;
    }

    public boolean zzqr() {
        if (this.zzajU) {
            return true;
        }
        for (DataSet dataSet : this.zzajS) {
            if (!dataSet.zzqr()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzKT, this.zzajH, this.zzajR, this.zzajT});
    }

    public String toString() {
        return zzt.zzt((Object)this).zzg("startTime", (Object)this.zzKT).zzg("endTime", (Object)this.zzajH).zzg("activity", (Object)this.zzajR).zzg("dataSets", this.zzajS).zzg("bucketType", (Object)Bucket.zzeb(this.zzajT)).zzg("serverHasMoreData", (Object)this.zzajU).toString();
    }

    public static String zzeb(int n) {
        switch (n) {
            case 1: {
                return "time";
            }
            case 3: {
                return "type";
            }
            case 4: {
                return "segment";
            }
            case 2: {
                return "session";
            }
            case 0: {
                return "unknown";
            }
        }
        return "bug";
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public long zzkt() {
        return this.zzKT;
    }

    public long zzqs() {
        return this.zzajH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

