/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import java.util.concurrent.TimeUnit;

public interface HistoryApi {
    public PendingResult<DataReadResult> readData(GoogleApiClient var1, DataReadRequest var2);

    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient var1, DataType var2);

    public PendingResult<Status> insertData(GoogleApiClient var1, DataSet var2);

    public PendingResult<Status> deleteData(GoogleApiClient var1, DataDeleteRequest var2);

    public static class ViewIntentBuilder {
        private final Context mContext;
        private final DataType zzajF;
        private DataSource zzajG;
        private long zzKT;
        private long zzajH;
        private String zzajI;

        public ViewIntentBuilder(Context context, DataType dataType) {
            this.mContext = context;
            this.zzajF = dataType;
        }

        public ViewIntentBuilder setTimeInterval(long start, long end, TimeUnit timeUnit) {
            this.zzKT = timeUnit.toMillis(start);
            this.zzajH = timeUnit.toMillis(end);
            return this;
        }

        public ViewIntentBuilder setDataSource(DataSource dataSource) {
            zzu.zzb((boolean)dataSource.getDataType().equals(this.zzajF), (String)"Data source %s is not for the data type %s", (Object[])new Object[]{dataSource, this.zzajF});
            this.zzajG = dataSource;
            return this;
        }

        public ViewIntentBuilder setPreferredApplication(String packageName) {
            this.zzajI = packageName;
            return this;
        }

        public Intent build() {
            zzu.zza((this.zzKT > 0L ? 1 : 0) != 0, (Object)"Start time must be set");
            zzu.zza((this.zzajH > this.zzKT ? 1 : 0) != 0, (Object)"End time must be set and after start time");
            Intent intent = new Intent("vnd.google.fitness.VIEW");
            intent.setType(DataType.getMimeType(this.zzajG.getDataType()));
            intent.putExtra("vnd.google.fitness.start_time", this.zzKT);
            intent.putExtra("vnd.google.fitness.end_time", this.zzajH);
            zzc.zza((SafeParcelable)this.zzajG, (Intent)intent, (String)"vnd.google.fitness.data_source");
            return this.zzj(intent);
        }

        private Intent zzj(Intent intent) {
            if (this.zzajI == null) {
                return intent;
            }
            Intent intent2 = new Intent(intent).setPackage(this.zzajI);
            ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent2, 0);
            if (resolveInfo != null) {
                String string = resolveInfo.activityInfo.name;
                intent2.setComponent(new ComponentName(this.zzajI, string));
                return intent2;
            }
            return intent;
        }
    }
}

