/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DailyTotalRequest;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataInsertRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzix;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzjy;

public class zzjt
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient client, DataSet dataSet) {
        return this.zza(client, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzv.zzb((Object)dataSet, (Object)"Must set the data set");
        zzv.zza((!dataSet.getDataPoints().isEmpty() ? 1 : 0) != 0, (Object)"Cannot use an empty data set");
        zzv.zzb((Object)dataSet.getDataSource().zzoM(), (Object)"Must set the app package name for the data source");
        return googleApiClient.zza((zza.zza)new zzir.zzc(googleApiClient){

            protected void zza(zzir zzir2) throws RemoteException {
                zzjy zzjy2 = new zzjy((zza.zzb<Status>)this);
                String string = zzir2.getContext().getPackageName();
                ((zzjc)zzir2.zzlX()).zza(new DataInsertRequest(dataSet, zzjy2, string, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient client, final DataDeleteRequest request) {
        return client.zza((zza.zza)new zzir.zzc(client){

            protected void zza(zzir zzir2) throws RemoteException {
                zzjy zzjy2 = new zzjy((zza.zzb<Status>)this);
                String string = zzir2.getContext().getPackageName();
                ((zzjc)zzir2.zzlX()).zza(new DataDeleteRequest(request, zzjy2, string));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient client, final DataReadRequest request) {
        return client.zza((zza.zza)new zzir.zza<DataReadResult>(client){

            protected void zza(zzir zzir2) throws RemoteException {
                zza zza2 = new zza((zza.zzb)this);
                String string = zzir2.getContext().getPackageName();
                ((zzjc)zzir2.zzlX()).zza(new DataReadRequest(request, zza2, string));
            }

            protected DataReadResult zzw(Status status) {
                return DataReadResult.zza(status, request);
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzw(x0);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient client, final DataType dataType) {
        return client.zza((zza.zza)new zzir.zza<DailyTotalResult>(client){

            protected void zza(zzir zzir2) throws RemoteException {
                zziw.zza zza2 = new zziw.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.setResult(dailyTotalResult);
                    }
                };
                String string = zzir2.getContext().getPackageName();
                DailyTotalRequest dailyTotalRequest = new DailyTotalRequest(zza2, dataType, string);
                ((zzjc)zzir2.zzlX()).zza(dailyTotalRequest);
            }

            protected DailyTotalResult zzx(Status status) {
                return DailyTotalResult.zzD(status);
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzx(x0);
            }
        });
    }

    private static class zza
    extends zzix.zza {
        private final zza.zzb<DataReadResult> zzKq;
        private int zzaeh = 0;
        private DataReadResult zzaei = null;

        private zza(zza.zzb<DataReadResult> zzb2) {
            this.zzKq = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                Log.v((String)"Fitness", (String)"Received batch result");
                if (this.zzaei == null) {
                    this.zzaei = dataReadResult;
                } else {
                    this.zzaei.zzb(dataReadResult);
                }
                ++this.zzaeh;
                if (this.zzaeh == this.zzaei.zzpD()) {
                    this.zzKq.zzj((Object)this.zzaei);
                }
            }
        }
    }
}

