/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.BleScanCallback;
import com.google.android.gms.fitness.request.zza;
import com.google.android.gms.fitness.request.zzaa;
import com.google.android.gms.fitness.request.zzn;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zzjm;
import java.util.Collections;
import java.util.List;

public class StartBleScanRequest
implements SafeParcelable {
    private final int zzzH;
    private final List<DataType> zzacO;
    private final zzn zzafD;
    private final int zzafE;
    private final zzjm zzaeH;
    private final String zzJd;
    public static final Parcelable.Creator<StartBleScanRequest> CREATOR = new zzaa();

    StartBleScanRequest(int versionCode, List<DataType> dataTypes, IBinder bleScanCallback, int timeoutSecs, IBinder callback, String packageName) {
        this.zzzH = versionCode;
        this.zzacO = dataTypes;
        this.zzafD = zzn.zza.zzaV(bleScanCallback);
        this.zzafE = timeoutSecs;
        this.zzaeH = callback == null ? null : zzjm.zza.zzaS(callback);
        this.zzJd = packageName;
    }

    private StartBleScanRequest(Builder builder) {
        this(zzhq.zzb((Object[])builder.zzafc), builder.zzafD, builder.zzafE, null, null);
    }

    public StartBleScanRequest(StartBleScanRequest request, zzjm callback, String packageName) {
        this(request.zzacO, request.zzafD, request.zzafE, callback, packageName);
    }

    public StartBleScanRequest(List<DataType> dataTypes, zzn bleScanCallback, int timeoutSecs, zzjm callback, String packageName) {
        this.zzzH = 3;
        this.zzacO = dataTypes;
        this.zzafD = bleScanCallback;
        this.zzafE = timeoutSecs;
        this.zzaeH = callback;
        this.zzJd = packageName;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzacO);
    }

    public int getTimeoutSecs() {
        return this.zzafE;
    }

    public IBinder zzpA() {
        return this.zzafD.asBinder();
    }

    public IBinder zzpf() {
        return this.zzaeH == null ? null : this.zzaeH.asBinder();
    }

    public String getPackageName() {
        return this.zzJd;
    }

    public String toString() {
        return zzu.zzq((Object)this).zzg("dataTypes", this.zzacO).zzg("timeoutSecs", (Object)this.zzafE).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzaa.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzafc = new DataType[0];
        private zzn zzafD;
        private int zzafE = 10;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzafc = dataTypes;
            return this;
        }

        public Builder setBleScanCallback(BleScanCallback bleScanCallback) {
            this.zza(zza.zza.zzpd().zza(bleScanCallback));
            return this;
        }

        public Builder zza(zzn zzn2) {
            this.zzafD = zzn2;
            return this;
        }

        public Builder setTimeoutSecs(int stopTimeSecs) {
            zzv.zzb((stopTimeSecs > 0 ? 1 : 0) != 0, (Object)"Stop time must be greater than zero");
            zzv.zzb((stopTimeSecs <= 60 ? 1 : 0) != 0, (Object)"Stop time must be less than 1 minute");
            this.zzafE = stopTimeSecs;
            return this;
        }

        public StartBleScanRequest build() {
            zzv.zza((this.zzafD != null ? 1 : 0) != 0, (Object)"Must set BleScanCallback");
            return new StartBleScanRequest(this);
        }
    }
}

