/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzu;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzjm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int zzzH;
    private final Session zzacG;
    private final List<DataSet> zzacQ;
    private final List<DataPoint> zzafw;
    private final zzjm zzaeH;
    private final String zzJd;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new zzu();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, IBinder callback, String packageName) {
        this.zzzH = versionCode;
        this.zzacG = session;
        this.zzacQ = Collections.unmodifiableList(dataSets);
        this.zzafw = Collections.unmodifiableList(aggregateDataPoints);
        this.zzaeH = callback == null ? null : zzjm.zza.zzaS(callback);
        this.zzJd = packageName;
    }

    private SessionInsertRequest(Builder builder) {
        this(builder.zzacG, builder.zzacQ, builder.zzafw, null, null);
    }

    public SessionInsertRequest(SessionInsertRequest request, zzjm callback, String packageName) {
        this(request.zzacG, request.zzacQ, request.zzafw, callback, packageName);
    }

    public SessionInsertRequest(Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints, zzjm callback, String packageName) {
        this.zzzH = 2;
        this.zzacG = session;
        this.zzacQ = Collections.unmodifiableList(dataSets);
        this.zzafw = Collections.unmodifiableList(aggregateDataPoints);
        this.zzaeH = callback;
        this.zzJd = packageName;
    }

    public Session getSession() {
        return this.zzacG;
    }

    public List<DataSet> getDataSets() {
        return this.zzacQ;
    }

    public List<DataPoint> getAggregateDataPoints() {
        return this.zzafw;
    }

    public IBinder zzpf() {
        return this.zzaeH == null ? null : this.zzaeH.asBinder();
    }

    public String getPackageName() {
        return this.zzJd;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SessionInsertRequest && this.zzb((SessionInsertRequest)o);
    }

    private boolean zzb(SessionInsertRequest sessionInsertRequest) {
        return com.google.android.gms.common.internal.zzu.equal((Object)this.zzacG, (Object)sessionInsertRequest.zzacG) && com.google.android.gms.common.internal.zzu.equal(this.zzacQ, sessionInsertRequest.zzacQ) && com.google.android.gms.common.internal.zzu.equal(this.zzafw, sessionInsertRequest.zzafw);
    }

    public int hashCode() {
        return com.google.android.gms.common.internal.zzu.hashCode((Object[])new Object[]{this.zzacG, this.zzacQ, this.zzafw});
    }

    public String toString() {
        return com.google.android.gms.common.internal.zzu.zzq((Object)this).zzg("session", (Object)this.zzacG).zzg("dataSets", this.zzacQ).zzg("aggregateDataPoints", this.zzafw).toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzu.zza(this, dest, flags);
    }

    public static class Builder {
        private Session zzacG;
        private List<DataSet> zzacQ = new ArrayList<DataSet>();
        private List<DataPoint> zzafw = new ArrayList<DataPoint>();
        private List<DataSource> zzafx = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.zzacG = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            zzv.zzb((dataSet != null ? 1 : 0) != 0, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            zzv.zza((!this.zzafx.contains(dataSource) ? 1 : 0) != 0, (String)"Data set for this data source %s is already added.", (Object[])new Object[]{dataSource});
            List<DataPoint> list = dataSet.getDataPoints();
            zzv.zzb((!list.isEmpty() ? 1 : 0) != 0, (Object)"No data points specified in the input data set.");
            this.zzafx.add(dataSource);
            this.zzacQ.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            zzv.zzb((aggregateDataPoint != null ? 1 : 0) != 0, (Object)"Must specify a valid aggregate data point.");
            long l = aggregateDataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = aggregateDataPoint.getEndTime(TimeUnit.NANOSECONDS);
            zzv.zzb((l > 0L && l2 > l ? 1 : 0) != 0, (String)"Aggregate data point should have valid start and end times: %s", (Object[])new Object[]{aggregateDataPoint});
            DataSource dataSource = aggregateDataPoint.getDataSource();
            zzv.zza((!this.zzafx.contains(dataSource) ? 1 : 0) != 0, (String)"Data set/Aggregate data point for this data source %s is already added.", (Object[])new Object[]{dataSource});
            this.zzafx.add(dataSource);
            this.zzafw.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            zzv.zza((this.zzacG != null ? 1 : 0) != 0, (Object)"Must specify a valid session.");
            zzv.zza((this.zzacG.getEndTime(TimeUnit.MILLISECONDS) != 0L ? 1 : 0) != 0, (Object)"Must specify a valid end time, cannot insert a continuing session.");
            this.zzpy();
            return new SessionInsertRequest(this);
        }

        private void zzd(DataPoint dataPoint) {
            this.zzf(dataPoint);
            this.zze(dataPoint);
        }

        private void zze(DataPoint dataPoint) {
            long l = this.zzacG.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzacG.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getStartTime(TimeUnit.NANOSECONDS);
            long l4 = dataPoint.getEndTime(TimeUnit.NANOSECONDS);
            if (l3 != 0L && l4 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l4 > l2) {
                    l4 = zzim.zza(l4, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzv.zza((l3 >= l && l4 <= l2 ? 1 : 0) != 0, (String)"Data point %s has start and end times outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (l4 != dataPoint.getEndTime(TimeUnit.NANOSECONDS)) {
                    Log.w((String)"Fitness", (String)String.format("Data point end time [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getEndTime(TimeUnit.NANOSECONDS), l4, timeUnit}));
                    dataPoint.setTimeInterval(l3, l4, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzf(DataPoint dataPoint) {
            long l = this.zzacG.getStartTime(TimeUnit.NANOSECONDS);
            long l2 = this.zzacG.getEndTime(TimeUnit.NANOSECONDS);
            long l3 = dataPoint.getTimestamp(TimeUnit.NANOSECONDS);
            if (l3 != 0L) {
                TimeUnit timeUnit = TimeUnit.MILLISECONDS;
                if (l3 < l || l3 > l2) {
                    l3 = zzim.zza(l3, TimeUnit.NANOSECONDS, timeUnit);
                }
                zzv.zza((l3 >= l && l3 <= l2 ? 1 : 0) != 0, (String)"Data point %s has time stamp outside session interval [%d, %d]", (Object[])new Object[]{dataPoint, l, l2});
                if (dataPoint.getTimestamp(TimeUnit.NANOSECONDS) != l3) {
                    Log.w((String)"Fitness", (String)String.format("Data point timestamp [%d] is truncated to [%d] to match the precision [%s] of the session start and end time", new Object[]{dataPoint.getTimestamp(TimeUnit.NANOSECONDS), l3, timeUnit}));
                    dataPoint.setTimestamp(l3, TimeUnit.NANOSECONDS);
                }
            }
        }

        private void zzpy() {
            for (DataSet object : this.zzacQ) {
                for (DataPoint dataPoint : object.getDataPoints()) {
                    this.zzd(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.zzafw) {
                this.zzd(dataPoint);
            }
        }
    }
}

