/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.zzh;
import com.google.android.gms.internal.zzhq;
import com.google.android.gms.internal.zziy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataSourcesRequest
implements SafeParcelable {
    private final int zzzH;
    private final List<DataType> zzacO;
    private final List<Integer> zzaeZ;
    private final boolean zzafa;
    private final zziy zzafb;
    private final String zzJd;
    public static final Parcelable.Creator<DataSourcesRequest> CREATOR = new zzh();

    DataSourcesRequest(int versionCode, List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, IBinder callback, String packageName) {
        this.zzzH = versionCode;
        this.zzacO = dataTypes;
        this.zzaeZ = dataSourceTypes;
        this.zzafa = includeDbOnlySources;
        this.zzafb = callback == null ? null : zziy.zza.zzaE(callback);
        this.zzJd = packageName;
    }

    private DataSourcesRequest(Builder builder) {
        this(zzhq.zzb((Object[])builder.zzafc), Arrays.asList(zzhq.zza((int[])builder.zzafd)), builder.zzafa, null, null);
    }

    public DataSourcesRequest(DataSourcesRequest request, zziy callback, String packageName) {
        this(request.zzacO, request.zzaeZ, request.zzafa, callback, packageName);
    }

    public DataSourcesRequest(List<DataType> dataTypes, List<Integer> dataSourceTypes, boolean includeDbOnlySources, zziy callback, String packageName) {
        this.zzzH = 3;
        this.zzacO = dataTypes;
        this.zzaeZ = dataSourceTypes;
        this.zzafa = includeDbOnlySources;
        this.zzafb = callback;
        this.zzJd = packageName;
    }

    public List<DataType> getDataTypes() {
        return Collections.unmodifiableList(this.zzacO);
    }

    public List<Integer> zzpo() {
        return this.zzaeZ;
    }

    public boolean zzpp() {
        return this.zzafa;
    }

    public IBinder zzpf() {
        return this.zzafb == null ? null : this.zzafb.asBinder();
    }

    public String getPackageName() {
        return this.zzJd;
    }

    public String toString() {
        zzu.zza zza2 = zzu.zzq((Object)this).zzg("dataTypes", this.zzacO).zzg("sourceTypes", this.zzaeZ);
        if (this.zzafa) {
            zza2.zzg("includeDbOnlySources", (Object)"true");
        }
        return zza2.toString();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzh.zza(this, parcel, flags);
    }

    public static class Builder {
        private DataType[] zzafc = new DataType[0];
        private int[] zzafd = new int[]{0, 1};
        private boolean zzafa = false;

        public Builder setDataTypes(DataType ... dataTypes) {
            this.zzafc = dataTypes;
            return this;
        }

        public Builder setDataSourceTypes(int ... dataSourceTypes) {
            this.zzafd = dataSourceTypes;
            return this;
        }

        public DataSourcesRequest build() {
            zzv.zza((this.zzafc.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data type");
            zzv.zza((this.zzafd.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one data source type");
            return new DataSourcesRequest(this);
        }
    }
}

